/*
 * Decompiled with CFR 0.152.
 */
package com.chrominance.game;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Filter;
import com.badlogic.gdx.physics.box2d.Fixture;
import com.badlogic.gdx.physics.box2d.RayCastCallback;
import com.chrominance.game.Model.ColorWall;
import com.chrominance.game.Model.DefaultWall;
import com.chrominance.game.Model.GameObject;
import com.chrominance.game.Model.GarbageCollector;
import com.chrominance.game.Model.Player;
import com.chrominance.game.Model.TileObject;
import com.chrominance.game.Model.WorldModel;
import com.chrominance.game.SoundController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;

public class AIController {
    private GarbageCollector garbageCollector;
    private WorldModel worldModel;
    private Vector2 previousDirection;
    private float alerted;
    private boolean hasRoaming;
    private final float MAX_ALERT = 4.0f;
    private boolean newAlert = false;
    private final boolean[] canseeplayer;
    private float stuckCounter = 0.0f;
    private Vector2 prevPosition;
    private Vector2 directionCache;
    private final Vector2 zeroVector = new Vector2(0.0f, 0.0f);
    private ArrayList<String> visitedCache;
    private Vector2 positionCache;
    private Map<Vector2, Vector2> previousPositionsCache;
    private List<Vector2> pathCache;
    private Queue<Vector2> positionsCache;
    public boolean stuck = false;

    public AIController(GarbageCollector garbageCollector, WorldModel worldModel) {
        this.garbageCollector = garbageCollector;
        this.worldModel = worldModel;
        this.directionCache = new Vector2();
        this.canseeplayer = new boolean[1];
        this.visitedCache = new ArrayList();
    }

    public GarbageCollector getGarbageCollector() {
        return this.garbageCollector;
    }

    public void update(float delta) {
        if (this.garbageCollector.isActive(this.worldModel.getColorMode())) {
            Filter f = new Filter();
            f.maskBits = (short)-1;
            this.garbageCollector.setFilterData(f);
            f = null;
            this.garbageCollector.setAwake(true);
            if (this.canSeePlayer()) {
                this.alerted = 4.0f;
                if (!this.newAlert) {
                    this.newAlert = true;
                    SoundController.playGCAlert();
                }
            } else if (this.alerted <= 0.0f) {
                this.newAlert = false;
            }
            this.directionCache.set(0.0f, 0.0f);
            if (this.alerted > 0.0f) {
                this.alerted -= delta;
                if (this.prevPosition == null) {
                    this.prevPosition = new Vector2(-1.0f, -1.0f);
                }
                this.directionCache = this.getDirectionAlongPathTowardsPlayer();
            }
            if (this.directionCache.len() == 0.0f) {
                if (this.garbageCollector.getPosition().epsilonEquals(this.worldModel.getPlayer().getPosition(), 2.0f)) {
                    this.directionCache = this.worldModel.getPlayer().getPosition().cpy().sub(this.garbageCollector.getPosition());
                } else if (this.garbageCollector.positions != null) {
                    this.directionCache = this.getRoamingDirection();
                }
            }
            this.garbageCollector.update(delta, this.directionCache.scl(GarbageCollector.DEFAULT_VELOCITY));
        } else {
            this.newAlert = false;
            Filter f = new Filter();
            f.maskBits = 0;
            this.garbageCollector.getBody().getFixtureList().get(0).setFilterData(f);
            f = null;
            this.garbageCollector.finishAnimation();
            this.garbageCollector.setAwake(false);
        }
    }

    private Vector2 getRoamingDirection() {
        this.garbageCollector.t += Gdx.graphics.getDeltaTime();
        if (new Vector2(this.garbageCollector.getX() * GameObject.gameScale, this.worldModel.boardToScreen(this.worldModel.getHeight() - 1) - (this.garbageCollector.getY() - 1.0f) * GameObject.gameScale).epsilonEquals(this.garbageCollector.positions[this.garbageCollector.vertexIndex], 10.0f)) {
            this.garbageCollector.vertexIndex += this.garbageCollector.dir;
            if (this.garbageCollector.vertexIndex == this.garbageCollector.roamPathParsed.length && this.garbageCollector.loop || this.garbageCollector.vertexIndex == -1) {
                this.garbageCollector.vertexIndex = 1;
                this.garbageCollector.dir = 1;
            } else if (this.garbageCollector.vertexIndex == this.garbageCollector.roamPathParsed.length) {
                this.garbageCollector.dir = -1;
                this.garbageCollector.vertexIndex = this.garbageCollector.roamPathParsed.length - 1;
                this.garbageCollector.vertexIndex += this.garbageCollector.dir;
            }
        }
        this.directionCache.set(this.garbageCollector.roamPathParsed[this.garbageCollector.vertexIndex]);
        return this.directionCache;
    }

    private boolean canSeePlayer() {
        final boolean[] canseeplayer = new boolean[1];
        Player p = this.worldModel.getPlayer();
        canseeplayer[0] = true;
        Vector2 gcp = this.garbageCollector.getPosition().cpy().sub(0.0f, this.garbageCollector.getDimension().y / 2.0f);
        Vector2 pp = p.getPosition().cpy().add(p.getHbOrigin().x / Player.gameScale, p.getHbOrigin().y / Player.gameScale);
        this.worldModel.getWorld().rayCast(new RayCastCallback(){

            @Override
            public float reportRayFixture(Fixture fixture, Vector2 point, Vector2 normal, float fraction) {
                GameObject o = (GameObject)fixture.getBody().getUserData();
                switch (o.getType()) {
                    case PLAYER: 
                    case HOLE: 
                    case PRESSUREPLATE: 
                    case GARBAGECOLLECTOR: {
                        return -1.0f;
                    }
                    case COLORWALL: {
                        if (AIController.this.garbageCollector.getColorMode() == o.getColorMode()) {
                            return -1.0f;
                        }
                        if (((ColorWall)o).isTopWall) {
                            return -1.0f;
                        }
                        if (fixture.getFilterData().maskBits == -1) {
                            canseeplayer[0] = false;
                            return 0.0f;
                        }
                        return -1.0f;
                    }
                    case DEFAULTWALL: {
                        if (!((DefaultWall)o).isTopWall) break;
                        return -1.0f;
                    }
                }
                if (AIController.this.garbageCollector.getColorMode() == o.getColorMode()) {
                    return -1.0f;
                }
                if (fixture.getFilterData().maskBits == -1) {
                    canseeplayer[0] = false;
                    return 0.0f;
                }
                return -1.0f;
            }
        }, gcp, pp);
        return canseeplayer[0];
    }

    private boolean isPassable(WorldModel.TileList tiles) {
        for (int i = 0; i < tiles.getSize(); ++i) {
            TileObject tile = tiles.get(i);
            if (tile instanceof ColorWall && ((ColorWall)tile).isTopWall) {
                if (i + 1 < tiles.getSize() && tiles.get(i + 1) instanceof DefaultWall) {
                    return false;
                }
                if (this.garbageCollector.getPosition().y - this.garbageCollector.getRadius() >= tile.getPosition().y - 1.0f + tile.getHeight()) {
                    return true;
                }
            }
            if (tile instanceof DefaultWall && ((DefaultWall)tile).isTopWall && this.garbageCollector.getPosition().y - this.garbageCollector.getRadius() >= tile.getPosition().y - 1.0f + tile.getHeight()) {
                return true;
            }
            if (tile instanceof DefaultWall && !((DefaultWall)tile).isTopWall) {
                return false;
            }
            if (!(tile instanceof ColorWall) || tile.getColorMode() == this.worldModel.getColorMode() || tile.getColorMode() == this.garbageCollector.getColorMode()) continue;
            return false;
        }
        return true;
    }

    private boolean isPassable(int x, int y) {
        WorldModel.TileList tiles = this.worldModel.getTileMap()[x][y];
        return this.isPassable(tiles);
    }

    private Vector2 getDirectionAlongPathTowardsPlayer() {
        if (this.positionsCache == null) {
            this.positionsCache = new LinkedList<Vector2>();
        }
        this.positionsCache.clear();
        this.visitedCache.clear();
        if (this.positionCache == null) {
            this.positionCache = new Vector2();
        }
        this.positionCache.set(this.garbageCollector.getPosition());
        int gcX = this.worldModel.screenToBoard(this.positionCache.x);
        int gcY = this.worldModel.screenToBoard(this.positionCache.y);
        Vector2 startPosition = new Vector2(gcX, gcY);
        this.positionsCache.add(startPosition);
        this.visitedCache.add(gcX + "_" + gcY);
        if (this.previousPositionsCache == null) {
            this.previousPositionsCache = new HashMap<Vector2, Vector2>();
        }
        this.previousPositionsCache.clear();
        if (this.pathCache == null) {
            this.pathCache = new ArrayList<Vector2>();
        }
        this.pathCache.clear();
        this.positionCache.set(this.worldModel.getPlayer().getPosition());
        int playerX = this.worldModel.screenToBoard(this.positionCache.x);
        int playerY = this.worldModel.screenToBoard(this.positionCache.y);
        Vector2 current = new Vector2();
        while (!this.positionsCache.isEmpty()) {
            Vector2 position = this.positionsCache.poll();
            if (position.x == (float)playerX && position.y == (float)playerY && position != startPosition) {
                this.pathCache = new ArrayList<Vector2>();
                current.set(position.x, position.y);
                while (current != null) {
                    this.pathCache.add(new Vector2(current));
                    current = this.previousPositionsCache.get(current);
                }
                break;
            }
            this.checkNeighbors((int)position.x, (int)position.y + 1, this.visitedCache, this.positionsCache, position, this.previousPositionsCache);
            this.checkNeighbors((int)position.x, (int)position.y - 1, this.visitedCache, this.positionsCache, position, this.previousPositionsCache);
            this.checkNeighbors((int)position.x + 1, (int)position.y, this.visitedCache, this.positionsCache, position, this.previousPositionsCache);
            this.checkNeighbors((int)position.x - 1, (int)position.y, this.visitedCache, this.positionsCache, position, this.previousPositionsCache);
        }
        if (this.pathCache.size() < 2) {
            return this.zeroVector;
        }
        ArrayList<Vector2> pathCacheDup = new ArrayList<Vector2>();
        boolean sadness = false;
        for (int j = this.pathCache.size() - 1; j >= 0; --j) {
            Vector2 tile = this.pathCache.get(j);
            if (this.worldModel.getTileMap()[(int)tile.x][(int)tile.y].get(0).isTopWall() && (double)(this.garbageCollector.getY() - this.garbageCollector.getRadius()) < (double)this.worldModel.getTileMap()[(int)tile.x][(int)tile.y].get(0).getY() - 1.0 + (double)this.worldModel.getTileMap()[(int)tile.x][(int)tile.y].get(0).getHeight() && !sadness && j > 0 && this.worldModel.getTileMap()[(int)tile.x][(int)tile.y].get(0).isActive(this.worldModel.getColorMode())) {
                pathCacheDup.add(0, new Vector2(tile.x, tile.y + 1.0f));
                sadness = true;
            }
            pathCacheDup.add(0, tile);
        }
        if (pathCacheDup.size() == 0) {
            System.out.println("i wanna die");
        }
        this.pathCache = pathCacheDup;
        int deltaX = (int)(this.pathCache.get((int)(this.pathCache.size() - 2)).x - this.pathCache.get((int)(this.pathCache.size() - 1)).x);
        int deltaY = (int)(this.pathCache.get((int)(this.pathCache.size() - 2)).y - this.pathCache.get((int)(this.pathCache.size() - 1)).y);
        Vector2 direction = new Vector2(deltaX, deltaY);
        return direction;
    }

    private void checkNeighbors(int x, int y, ArrayList<String> visited, Queue<Vector2> positions, Vector2 position, Map<Vector2, Vector2> previousPositions) {
        if (this.worldModel.inBounds(x, y) && !visited.contains(x + "_" + y) && this.isPassable(x, y)) {
            Vector2 neighbor = new Vector2(x, y);
            positions.add(neighbor);
            visited.add(x + "_" + y);
            previousPositions.put(neighbor, position);
        }
    }
}

