/*
 * Decompiled with CFR 0.152.
 */
package com.chrominance.game;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.utils.viewport.ScreenViewport;
import com.chrominance.game.util.JsonAssetManager;
import com.chrominance.game.util.ScreenListener;

public abstract class AbstractScreen
implements Screen {
    public Stage stage = new Stage(new ScreenViewport());
    protected Table table = new Table();
    protected ScreenListener listener;
    protected static Skin skin;
    protected static Skin skin1;

    public AbstractScreen() {
        this.table.setFillParent(true);
        this.stage.addActor(this.table);
        this.table.defaults().minWidth(100.0f);
        this.table.defaults().minHeight(50.0f);
    }

    public void setScreenListener(ScreenListener listener) {
        this.listener = listener;
    }

    public void takeControl() {
        Gdx.input.setInputProcessor(this.stage);
    }

    @Override
    public void render(float delta) {
        Gdx.gl.glClear(16384);
        this.stage.act(delta);
        this.stage.draw();
    }

    @Override
    public void resize(int width, int height) {
        this.stage.getViewport().update(width, height, true);
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void hide() {
    }

    @Override
    public void dispose() {
        this.stage.dispose();
    }

    public static void initSkin() {
        skin1 = JsonAssetManager.getInstance().getEntry("quantumSkin", Skin.class);
        skin = JsonAssetManager.getInstance().getEntry("chrominance", Skin.class);
    }

    public abstract void init();
}

