/*
 * Decompiled with CFR 0.152.
 */
package com.chrominance.game;

import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.math.Vector3;
import java.util.Random;

public class CameraShake {
    float[] samples;
    Random rand = new Random();
    float internalTimer = 0.0f;
    float shakeDuration = 0.0f;
    int duration = 1;
    int frequency = 60;
    float amplitude = 5.0f;
    boolean falloff = true;
    int sampleCount = this.duration * this.frequency;

    public CameraShake() {
        this.samples = new float[this.sampleCount];
        for (int i = 0; i < this.sampleCount; ++i) {
            this.samples[i] = this.rand.nextFloat() * 2.0f - 1.0f;
        }
    }

    public void update(float dt, Camera camera, Vector3 center) {
        this.internalTimer += dt;
        if (this.internalTimer > (float)this.duration) {
            this.internalTimer -= (float)this.duration;
        }
        if (this.shakeDuration > 0.0f) {
            this.shakeDuration -= dt;
            float shakeTime = this.internalTimer * (float)this.frequency;
            int first = (int)shakeTime % this.sampleCount;
            int second = (first + 1) % this.sampleCount;
            int third = (first + 2) % this.sampleCount;
            float deltaT = shakeTime - (float)((int)shakeTime);
            float deltaX = this.samples[first] * deltaT + this.samples[second] * (1.0f - deltaT);
            float deltaY = this.samples[second] * deltaT + this.samples[third] * (1.0f - deltaT);
            camera.position.x = center.x + deltaX * this.amplitude * (this.falloff ? Math.min(this.shakeDuration, 1.0f) : 1.0f);
            camera.position.y = center.y + deltaY * this.amplitude * (this.falloff ? Math.min(this.shakeDuration, 1.0f) : 1.0f);
        }
    }

    public void shake(float d) {
        this.shakeDuration = d;
    }
}

