/*
 * Decompiled with CFR 0.152.
 */
package com.chrominance.game;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Contact;
import com.badlogic.gdx.physics.box2d.ContactImpulse;
import com.badlogic.gdx.physics.box2d.ContactListener;
import com.badlogic.gdx.physics.box2d.Manifold;
import com.badlogic.gdx.utils.Array;
import com.chrominance.game.Model.ColorWall;
import com.chrominance.game.Model.GameObject;
import com.chrominance.game.Model.GarbageCollector;
import com.chrominance.game.Model.Hole;
import com.chrominance.game.Model.Player;
import com.chrominance.game.Model.PressurePlate;
import com.chrominance.game.Model.WorldModel;
import com.chrominance.game.SoundController;

public class CollisionListener
implements ContactListener {
    private static final float PUSH_CONSTANT = 5.0f;
    private Vector2 pushConstantCache;
    private static final float OVERLAP_CONSTANT = 0.875f;
    private WorldModel worldModel;
    private static final Vector2 zeroVector = new Vector2(0.0f, 0.0f);
    private Vector2 bodyACache;
    private Vector2 bodyBCache;

    public CollisionListener(WorldModel wm) {
        this.worldModel = wm;
        this.pushConstantCache = new Vector2();
        this.bodyACache = new Vector2();
        this.bodyBCache = new Vector2();
    }

    @Override
    public void beginContact(Contact contact) {
        GameObject objA = (GameObject)contact.getFixtureA().getBody().getUserData();
        GameObject objB = (GameObject)contact.getFixtureB().getBody().getUserData();
        GameObject.ObjectType typeA = objA.getType();
        GameObject.ObjectType typeB = objB.getType();
        if (typeA == GameObject.ObjectType.EXIT && typeB == GameObject.ObjectType.PLAYER || typeB == GameObject.ObjectType.EXIT && typeA == GameObject.ObjectType.PLAYER) {
            this.worldModel.finished = true;
        } else if (typeA == GameObject.ObjectType.HOLE && typeB == GameObject.ObjectType.PLAYER || typeB == GameObject.ObjectType.HOLE && typeA == GameObject.ObjectType.PLAYER) {
            this.worldModel.getPlayer().updateHealth(-100);
            SoundController.playPlayerDeath();
        } else if (typeA == GameObject.ObjectType.PLAYER && typeB == GameObject.ObjectType.GARBAGECOLLECTOR) {
            GarbageCollector gc = (GarbageCollector)objB;
            if (!contact.getFixtureB().isSensor() && gc.getAnimState() != GarbageCollector.AnimationState.DEATH) {
                this.worldModel.getPlayer().updateHealth(-100);
                SoundController.playPlayerDeath();
                gc.getBody().setLinearVelocity(0.0f, 0.0f);
            }
        } else if (typeB == GameObject.ObjectType.PLAYER && typeA == GameObject.ObjectType.GARBAGECOLLECTOR) {
            GarbageCollector gc = (GarbageCollector)objA;
            if (!contact.getFixtureA().isSensor() && gc.getAnimState() != GarbageCollector.AnimationState.DEATH) {
                this.worldModel.getPlayer().updateHealth(-100);
                SoundController.playPlayerDeath();
                gc.getBody().setLinearVelocity(0.0f, 0.0f);
            }
        } else if (typeA == GameObject.ObjectType.GARBAGECOLLECTOR && typeB == GameObject.ObjectType.GARBAGECOLLECTOR) {
            if (!contact.getFixtureA().isSensor() && !contact.getFixtureB().isSensor()) {
                this.pushConstantCache.set(5.0f, 5.0f);
                contact.getFixtureA().getBody().applyLinearImpulse(this.pushConstantCache, zeroVector, true);
                contact.getFixtureB().getBody().applyLinearImpulse(this.pushConstantCache.scl(-1.0f), zeroVector, true);
            }
        } else if (typeA == GameObject.ObjectType.GARBAGECOLLECTOR && typeB == GameObject.ObjectType.COLORWALL) {
            if (contact.getFixtureA().isSensor()) {
                ColorWall wall = (ColorWall)objB;
                wall.setPriority(false);
            }
        } else if (typeB == GameObject.ObjectType.GARBAGECOLLECTOR && typeA == GameObject.ObjectType.COLORWALL) {
            if (contact.getFixtureB().isSensor()) {
                ColorWall wall = (ColorWall)objA;
                wall.setPriority(false);
            }
        } else if (typeA == GameObject.ObjectType.HOLE && typeB == GameObject.ObjectType.GARBAGECOLLECTOR) {
            if (contact.getFixtureB().isSensor()) {
                return;
            }
            GarbageCollector gc = (GarbageCollector)objB;
            Hole hole = (Hole)objA;
            if (gc.getColorMode() == hole.getColorMode() && gc.getAnimState() != GarbageCollector.AnimationState.DEATH) {
                gc.setAnimState(GarbageCollector.AnimationState.DEATH);
                gc.setRespawnFilter();
                this.worldModel.fillHole(hole);
                this.worldModel.getPlayer().setPaint(this.worldModel.getPlayer().getPaint() + 1);
                SoundController.playGCDeath();
            }
        } else if (typeB == GameObject.ObjectType.HOLE && typeA == GameObject.ObjectType.GARBAGECOLLECTOR) {
            if (contact.getFixtureA().isSensor()) {
                return;
            }
            GarbageCollector gc = (GarbageCollector)objA;
            Hole hole = (Hole)objB;
            if (gc.getColorMode() == hole.getColorMode() && gc.getAnimState() != GarbageCollector.AnimationState.DEATH) {
                gc.setAnimState(GarbageCollector.AnimationState.DEATH);
                gc.setRespawnFilter();
                this.worldModel.fillHole(hole);
                this.worldModel.getPlayer().setPaint(this.worldModel.getPlayer().getPaint() + 1);
                SoundController.playGCDeath();
            }
        } else if (typeA == GameObject.ObjectType.PRESSUREPLATE) {
            if (typeB == GameObject.ObjectType.GARBAGECOLLECTOR && contact.getFixtureB().isSensor()) {
                return;
            }
            PressurePlate a = (PressurePlate)objA;
            boolean playDoorOpen = true;
            if (!this.worldModel.doorSet.get(a.getSetid()).getOpened()) {
                SoundController.playPressurePlate(this.worldModel.getPlayer().getPosition().cpy().sub(a.getPosition()).len());
            } else {
                playDoorOpen = false;
            }
            if (typeB == GameObject.ObjectType.PLAYER) {
                a.setSteppedOn(true);
            }
            if (typeB == GameObject.ObjectType.GARBAGECOLLECTOR && objA.getColorMode() == objB.getColorMode()) {
                a.setSteppedOn(true);
            }
            Array<PressurePlate> s = WorldModel.pressureSet.get(a.getSetid());
            boolean unlockDoor = true;
            int num = 0;
            for (PressurePlate p : s) {
                if (!p.getSteppedOn()) {
                    unlockDoor = false;
                    continue;
                }
                ++num;
            }
            this.worldModel.doorSet.get(a.getSetid()).updateGate(num);
            if (unlockDoor) {
                this.worldModel.doorSet.get(a.getSetid()).setOpened(true);
                if (playDoorOpen) {
                    SoundController.playDoorOpen(this.worldModel.getPlayer().getPosition().cpy().sub(this.worldModel.doorSet.get(a.getSetid()).getPosition()).len());
                }
            }
        } else if (typeB == GameObject.ObjectType.PRESSUREPLATE) {
            if (typeA == GameObject.ObjectType.GARBAGECOLLECTOR && contact.getFixtureA().isSensor()) {
                return;
            }
            PressurePlate b = (PressurePlate)objB;
            boolean playDoorOpen = true;
            if (!this.worldModel.doorSet.get(b.getSetid()).getOpened()) {
                SoundController.playPressurePlate(this.worldModel.getPlayer().getPosition().cpy().sub(b.getPosition()).len());
            } else {
                playDoorOpen = false;
            }
            if (typeA == GameObject.ObjectType.PLAYER) {
                b.setSteppedOn(true);
            }
            if (typeA == GameObject.ObjectType.GARBAGECOLLECTOR && objA.getColorMode() == objB.getColorMode()) {
                b.setSteppedOn(true);
            }
            Array<PressurePlate> s = WorldModel.pressureSet.get(b.getSetid());
            boolean unlockDoor = true;
            int num = 0;
            for (PressurePlate p : s) {
                if (!p.getSteppedOn()) {
                    unlockDoor = false;
                    continue;
                }
                ++num;
            }
            this.worldModel.doorSet.get(b.getSetid()).updateGate(num);
            if (unlockDoor) {
                this.worldModel.doorSet.get(b.getSetid()).setOpened(true);
                if (playDoorOpen) {
                    SoundController.playDoorOpen(this.worldModel.getPlayer().getPosition().cpy().sub(this.worldModel.doorSet.get(b.getSetid()).getPosition()).len());
                }
            }
        }
    }

    @Override
    public void endContact(Contact contact) {
        GameObject objA = (GameObject)contact.getFixtureA().getBody().getUserData();
        GameObject objB = (GameObject)contact.getFixtureB().getBody().getUserData();
        GameObject.ObjectType typeA = objA.getType();
        GameObject.ObjectType typeB = objB.getType();
        boolean popped = false;
        if (typeA == GameObject.ObjectType.PRESSUREPLATE) {
            if (typeB == GameObject.ObjectType.GARBAGECOLLECTOR && objB.isSensor()) {
                return;
            }
            int sid = ((PressurePlate)objA).getSetid();
            if (!this.worldModel.doorSet.get(sid).getOpened()) {
                PressurePlate a = (PressurePlate)objA;
                a.setSteppedOn(false);
                int num = 0;
                Array<PressurePlate> s = WorldModel.pressureSet.get(a.getSetid());
                for (PressurePlate p : s) {
                    if (!p.getSteppedOn()) continue;
                    ++num;
                }
                this.worldModel.doorSet.get(sid).updateGate(num);
            }
        } else if (typeB == GameObject.ObjectType.PRESSUREPLATE) {
            if (typeA == GameObject.ObjectType.GARBAGECOLLECTOR && objA.isSensor()) {
                return;
            }
            int sid = ((PressurePlate)objA).getSetid();
            if (!this.worldModel.doorSet.get(sid).getOpened()) {
                PressurePlate b = (PressurePlate)objB;
                b.setSteppedOn(false);
                int num = 0;
                Array<PressurePlate> s = WorldModel.pressureSet.get(b.getSetid());
                for (PressurePlate p : s) {
                    if (!p.getSteppedOn()) continue;
                    ++num;
                }
                this.worldModel.doorSet.get(sid).updateGate(num);
            }
        } else if (typeA == GameObject.ObjectType.GARBAGECOLLECTOR && typeB == GameObject.ObjectType.COLORWALL) {
            if (contact.getFixtureA().isSensor()) {
                ColorWall wall = (ColorWall)objB;
                wall.setPriority(true);
            }
        } else if (typeB == GameObject.ObjectType.GARBAGECOLLECTOR && typeA == GameObject.ObjectType.COLORWALL && contact.getFixtureB().isSensor()) {
            ColorWall wall = (ColorWall)objA;
            wall.setPriority(true);
        }
    }

    @Override
    public void preSolve(Contact contact, Manifold oldManifold) {
        GameObject bodyA = (GameObject)contact.getFixtureA().getBody().getUserData();
        GameObject bodyB = (GameObject)contact.getFixtureB().getBody().getUserData();
        GameObject.ObjectType typeA = bodyA.getType();
        GameObject.ObjectType typeB = bodyB.getType();
        if (typeA == GameObject.ObjectType.GARBAGECOLLECTOR && typeB == GameObject.ObjectType.COLORWALL) {
            GarbageCollector gc = (GarbageCollector)bodyA;
            ColorWall wall = (ColorWall)bodyB;
            if (gc.getColorMode() == wall.getColorMode()) {
                contact.setEnabled(false);
            } else {
                this.bodyACache.set(bodyA.getPosition());
                this.bodyBCache.set(bodyB.getPosition());
                float dist = this.bodyBCache.sub(this.bodyACache).len();
                if (dist < 0.875f && typeA == GameObject.ObjectType.GARBAGECOLLECTOR && ((GarbageCollector)bodyA).getAnimState() != GarbageCollector.AnimationState.TELEPORTING) {
                    ((GarbageCollector)bodyA).setAnimState(GarbageCollector.AnimationState.TELEPORTING);
                    ((GarbageCollector)bodyA).setRespawnFilter();
                    SoundController.playGCDeath();
                }
            }
        } else if (typeA == GameObject.ObjectType.COLORWALL && typeB == GameObject.ObjectType.GARBAGECOLLECTOR) {
            GarbageCollector gc = (GarbageCollector)bodyB;
            ColorWall wall = (ColorWall)bodyA;
            if (gc.getColorMode() == wall.getColorMode()) {
                contact.setEnabled(false);
            } else {
                this.bodyACache.set(bodyA.getPosition());
                this.bodyBCache.set(bodyB.getPosition());
                float dist = this.bodyBCache.sub(this.bodyACache).len();
                if (dist < 0.875f && ((GarbageCollector)bodyB).getAnimState() != GarbageCollector.AnimationState.TELEPORTING) {
                    ((GarbageCollector)bodyB).setAnimState(GarbageCollector.AnimationState.TELEPORTING);
                    ((GarbageCollector)bodyB).setRespawnFilter();
                    SoundController.playGCDeath();
                }
            }
        } else if (typeA == GameObject.ObjectType.PLAYER && typeB == GameObject.ObjectType.COLORWALL) {
            Player player = (Player)bodyA;
            ColorWall wall = (ColorWall)bodyB;
            this.bodyACache.set(bodyA.getPosition());
            this.bodyBCache.set(bodyB.getPosition());
            float dist = this.bodyBCache.sub(this.bodyACache).len();
            if (dist < 0.875f && !wall.isTopWall) {
                player.updateHealth(-100);
                SoundController.playPlayerDeath();
            }
        } else if (typeA == GameObject.ObjectType.COLORWALL && typeB == GameObject.ObjectType.PLAYER) {
            Player player = (Player)bodyB;
            ColorWall wall = (ColorWall)bodyA;
            this.bodyACache.set(bodyA.getPosition());
            this.bodyBCache.set(bodyB.getPosition());
            float dist = this.bodyBCache.sub(this.bodyACache).len();
            if (dist < 0.875f && !wall.isTopWall) {
                player.updateHealth(-100);
                SoundController.playPlayerDeath();
            }
        } else if (typeA == GameObject.ObjectType.GARBAGECOLLECTOR && typeB == GameObject.ObjectType.GARBAGECOLLECTOR) {
            this.bodyACache.set(bodyA.getPosition());
            this.bodyBCache.set(bodyB.getPosition());
            float dist = this.bodyBCache.sub(this.bodyACache).len();
            if (dist < 0.875f) {
                if (((GarbageCollector)bodyB).getAnimState() != GarbageCollector.AnimationState.TELEPORTING) {
                    ((GarbageCollector)bodyB).setAnimState(GarbageCollector.AnimationState.TELEPORTING);
                    ((GarbageCollector)bodyB).setRespawnFilter();
                    SoundController.playGCDeath();
                }
                if (((GarbageCollector)bodyA).getAnimState() != GarbageCollector.AnimationState.TELEPORTING) {
                    ((GarbageCollector)bodyA).setAnimState(GarbageCollector.AnimationState.TELEPORTING);
                    ((GarbageCollector)bodyA).setRespawnFilter();
                    SoundController.playGCDeath();
                }
            }
        }
    }

    @Override
    public void postSolve(Contact contact, ContactImpulse impulse) {
    }
}

