/*
 * Decompiled with CFR 0.152.
 */
package com.chrominance.game;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.utils.BaseDrawable;
import com.chrominance.game.util.FilmStrip;
import com.chrominance.game.util.JsonAssetManager;

public class DrawStatic
extends BaseDrawable {
    private static DrawStatic instance = null;
    private FilmStrip frames = (FilmStrip)JsonAssetManager.getInstance().getEntry("static", TextureRegion.class);
    private float count = 0.0f;
    private static final int NUM_FRAMES = 8;
    private static final float ANIMATION_SPEED = 0.3f;

    public static DrawStatic getInstance() {
        if (instance != null) {
            return instance;
        }
        return new DrawStatic();
    }

    private DrawStatic() {
    }

    @Override
    public void draw(Batch batch, float x, float y, float width, float height) {
        this.frames.setFrame((int)this.count);
        this.count += 0.3f;
        if (this.count >= 8.0f) {
            this.count = 0.0f;
        }
        Gdx.gl.glClearColor(0.2f, 0.2f, 0.2f, 1.0f);
        Gdx.gl20.glClearDepthf(1.0f);
        Gdx.gl20.glClear(0x4000 | 0x100);
        batch.draw(this.frames, x, y, width, height);
    }
}

