/*
 * Decompiled with CFR 0.152.
 */
package com.chrominance.game;

import com.badlogic.gdx.Game;
import com.badlogic.gdx.Gdx;
import com.chrominance.game.AbstractScreen;
import com.chrominance.game.GameEngine;
import com.chrominance.game.LevelScreen;
import com.chrominance.game.LoadingScreen;
import com.chrominance.game.LoseScreen;
import com.chrominance.game.MenuScreen;
import com.chrominance.game.SavedGameParser;
import com.chrominance.game.SettingsScreen;
import com.chrominance.game.SoundController;
import com.chrominance.game.WinScreen;
import com.chrominance.game.util.ScreenListener;

public class GDXRoot
extends Game
implements ScreenListener {
    private LoadingScreen loadScreen;
    private MenuScreen menuScreen;
    private GameEngine gameScreen;
    private LevelScreen levelScreen;
    private SettingsScreen settingsScreen;
    private WinScreen winScreen;
    private LoseScreen loseScreen;

    @Override
    public void create() {
        this.loadScreen = new LoadingScreen();
        this.gameScreen = new GameEngine();
        this.menuScreen = new MenuScreen();
        this.levelScreen = new LevelScreen();
        this.settingsScreen = new SettingsScreen();
        this.winScreen = new WinScreen();
        this.loseScreen = new LoseScreen();
        try {
            SavedGameParser.parse();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Could not load save file");
            Gdx.app.exit();
        }
        this.gameScreen.preLoadContent();
        this.loadScreen.setScreenListener(this);
        this.menuScreen.setScreenListener(this);
        this.gameScreen.setScreenListener(this);
        this.levelScreen.setScreenListener(this);
        this.settingsScreen.setScreenListener(this);
        this.winScreen.setScreenListener(this);
        this.loseScreen.setScreenListener(this);
        SoundController.getInstance();
        SoundController.init();
        this.switchToScreen(ScreenType.LOAD, ScreenType.LOAD, 0);
    }

    @Override
    public void render() {
        super.render();
    }

    @Override
    public void dispose() {
        if (this.loadScreen != null) {
            this.loadScreen.dispose();
        }
        this.menuScreen.dispose();
        this.gameScreen.dispose();
        this.winScreen.dispose();
        this.levelScreen.dispose();
        this.settingsScreen.dispose();
        this.loseScreen.dispose();
        this.menuScreen = null;
        this.gameScreen = null;
        this.winScreen = null;
        this.levelScreen = null;
        this.settingsScreen = null;
        this.loseScreen = null;
    }

    @Override
    public void switchToScreen(ScreenType current, ScreenType to, int data) {
        switch (to) {
            case LOAD: {
                this.setScreen(this.loadScreen);
                break;
            }
            case MENU: {
                this.gameScreen.loadContent();
                if (current.equals((Object)ScreenType.LOAD)) {
                    AbstractScreen.initSkin();
                    this.menuScreen.init();
                    this.gameScreen.init();
                    this.winScreen.init();
                    this.levelScreen.init();
                    this.settingsScreen.init();
                    this.loseScreen.init();
                }
                SoundController.getInstance();
                SoundController.playMenu();
                this.setScreen(this.menuScreen);
                if (current != ScreenType.LOAD) break;
                this.loadScreen.dispose();
                this.loadScreen = null;
                break;
            }
            case GAME: {
                this.gameScreen.initWorld();
                this.gameScreen.setLevel(data);
                SoundController.getInstance().disposeMenu();
                SoundController.getInstance();
                SoundController.playBackground();
                this.setScreen(this.gameScreen);
                break;
            }
            case LEVELS: {
                this.setScreen(this.levelScreen);
                break;
            }
            case SETTINGS: {
                this.setScreen(this.settingsScreen);
                break;
            }
            case WIN: {
                this.winScreen.setLevel(data);
                this.setScreen(this.winScreen);
                break;
            }
            case LOSE: {
                this.loseScreen.setLevel(data);
                this.setScreen(this.loseScreen);
                break;
            }
        }
    }

    public static enum ScreenType {
        LOAD,
        MENU,
        LEVELS,
        SETTINGS,
        GAME,
        WIN,
        LOSE;

    }
}

