/*
 * Decompiled with CFR 0.152.
 */
package com.chrominance.game;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import com.badlogic.gdx.graphics.g2d.PolygonSpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Affine2;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.viewport.FitViewport;
import com.badlogic.gdx.utils.viewport.ScreenViewport;
import com.badlogic.gdx.utils.viewport.Viewport;
import com.chrominance.game.InputController;
import com.chrominance.game.Model.DefaultFloor;
import com.chrominance.game.Model.Door;
import com.chrominance.game.Model.GameObject;
import com.chrominance.game.Model.TileObject;
import com.chrominance.game.Model.WorldModel;
import com.chrominance.game.util.JsonAssetManager;

public class GameCanvas {
    private int fontScale;
    private int windowWidth;
    private int windowHeight;
    protected PolygonSpriteBatch spriteBatch;
    private Affine2 local;
    private TextureRegion holder;
    private OrthographicCamera spriteCam;
    private int worldWidth;
    private int worldHeight;
    private Viewport view;
    private OrthographicCamera uiCam;
    private Viewport uiView;
    public static final int UI_SIZE = 80;
    private OrthographicCamera mmCam;
    private Viewport mmView;
    private Texture minimapBackground;
    private int minimapTileSize;
    private int minimapWidth;
    private int minimapHeight;
    private float minimapTileRatio;
    private int minimapBorderWidth = 10;
    public static Color darkPurple = new Color(0.345f, 0.345f, 0.486f, 1.0f);
    private Color lightPurple = new Color(0.741f, 0.706f, 0.839f, 1.0f);
    private Color darkdarkPurple = new Color(0.1764706f, 0.1764706f, 0.24313726f, 1.0f);
    private Color cyanDark = new Color(0.043f, 0.459f, 0.353f, 1.0f);
    private Color cyanLight = new Color(0.063f, 0.686f, 0.608f, 1.0f);
    private Color magentaDark = new Color(0.71f, 0.075f, 0.8f, 1.0f);
    private Color magentaLight = new Color(0.929f, 0.239f, 0.843f, 1.0f);
    private Color yellowDark = new Color(0.843f, 0.745f, 0.075f, 1.0f);
    private Color yellowLight = new Color(0.875f, 0.945f, 0.388f, 1.0f);
    private Texture[] signs;
    private Texture[] paintingSigns;
    private BitmapFont textFont;
    private Texture arcs;
    private int minimapX;
    private DefaultFloor defFloor;

    public GameCanvas() {
        this.spriteBatch = new PolygonSpriteBatch();
        this.holder = new TextureRegion();
        this.windowWidth = Gdx.graphics.getWidth();
        this.windowHeight = Gdx.graphics.getHeight();
        this.spriteCam = new OrthographicCamera(this.getWindowWidth(), this.getWindowHeight());
        this.view = new FitViewport(this.getWindowWidth(), (float)(this.getWindowHeight() - 80), this.spriteCam);
        this.view.setScreenBounds(0, 80, this.getWindowWidth(), this.getWindowHeight() - 80);
        this.view.apply();
        this.spriteCam.setToOrtho(false);
        this.spriteCam.position.set(this.spriteCam.viewportWidth / 2.0f, this.spriteCam.viewportHeight / 2.0f, 0.0f);
        this.spriteCam.zoom = 0.95f;
        this.spriteCam.update();
        this.spriteBatch.setProjectionMatrix(this.spriteCam.combined);
        this.uiCam = new OrthographicCamera(this.getWindowWidth(), this.getWindowHeight());
        this.uiView = new ScreenViewport(this.uiCam);
        this.uiCam.setToOrtho(false);
        this.uiCam.update();
        this.mmCam = new OrthographicCamera(this.getWindowWidth(), this.getWindowHeight());
        this.mmView = new ScreenViewport(this.mmCam);
        this.mmCam.setToOrtho(false);
        this.mmCam.update();
        this.local = new Affine2();
        int size = 60;
        int centerX = this.getWindowWidth() / 2 - size / 2;
        int centerY = 40 - size / 2;
        this.textFont = new BitmapFont();
        this.fontScale = 2;
        this.textFont.getData().setScale(this.fontScale);
        this.signs = new Texture[4];
        this.signs[0] = this.drawSign(size, size, size / 2, this.cyanLight, this.cyanDark, centerX - 3 * size, centerY);
        this.signs[1] = this.drawSign(size, size, size / 2, this.magentaLight, this.magentaDark, centerX, centerY);
        this.signs[2] = this.drawSign(size, size, size / 2, this.yellowLight, this.yellowDark, centerX + 3 * size, centerY);
        this.signs[3] = this.drawSign(size, size, size / 2, Color.WHITE, new Color(0.663f, 0.663f, 0.633f, 1.0f), centerX - 8 * size, centerY);
        this.paintingSigns = new Texture[4];
        this.paintingSigns[0] = this.drawSign(size, size, size / 2, this.cyanDark, this.cyanLight, centerX - 3 * size, centerY);
        this.paintingSigns[1] = this.drawSign(size, size, size / 2, this.magentaDark, this.magentaLight, centerX, centerY);
        this.paintingSigns[2] = this.drawSign(size, size, size / 2, this.yellowDark, this.yellowLight, centerX + 3 * size, centerY);
        this.paintingSigns[3] = this.drawSign(size, size, size / 2, new Color(0.663f, 0.663f, 0.633f, 1.0f), Color.WHITE, centerX - 8 * size, centerY);
    }

    public void dispose() {
        this.spriteBatch.dispose();
        if (this.minimapBackground != null) {
            this.minimapBackground.dispose();
            this.minimapBackground = null;
        }
        this.spriteBatch = null;
        this.local = null;
        this.defFloor = null;
    }

    public OrthographicCamera getCamera() {
        return this.spriteCam;
    }

    public void lookAt(float x, float y) {
        this.spriteCam.position.set(x, y, 0.0f);
        float effectiveViewportWidth = this.spriteCam.viewportWidth * this.spriteCam.zoom;
        float effectiveViewportHeight = this.spriteCam.viewportHeight * this.spriteCam.zoom;
        this.spriteCam.position.x = MathUtils.clamp(this.spriteCam.position.x, effectiveViewportWidth / 2.0f, (float)this.worldWidth - effectiveViewportWidth / 2.0f);
        this.spriteCam.position.y = MathUtils.clamp(this.spriteCam.position.y, effectiveViewportHeight / 2.0f, (float)this.worldHeight - effectiveViewportHeight / 2.0f);
    }

    public void setWorldSize(int width, int height) {
        this.worldWidth = width;
        this.worldHeight = height;
    }

    public void begin() {
        this.begin(true);
    }

    public void begin(boolean clear) {
        this.spriteCam.update();
        this.view.update(this.getWindowWidth(), this.getWindowHeight() - 80);
        this.spriteBatch.setProjectionMatrix(this.spriteCam.combined);
        this.view.setScreenY(80);
        this.uiView.update(this.getWindowWidth(), this.getWindowHeight());
        this.uiCam.update();
        this.view.apply();
        this.spriteBatch.begin();
        if (clear) {
            Gdx.gl20.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
            Gdx.gl20.glClearDepthf(1.0f);
            Gdx.gl20.glClear(0x4000 | 0x100);
        }
    }

    public void end() {
        this.spriteBatch.end();
        this.uiView.apply();
    }

    private void createMinimapBase(WorldModel world, float minimapScale) {
        float worldRatio = (float)this.worldWidth / (float)this.worldHeight;
        this.minimapHeight = (int)(0.5f + (float)this.worldHeight * minimapScale);
        this.minimapWidth = (int)(0.5f + (float)this.minimapHeight * worldRatio);
        this.minimapTileRatio = (float)this.minimapWidth / (float)this.worldWidth;
        this.minimapTileSize = (int)((double)((float)world.getTileSize() * this.minimapTileRatio) - 0.5);
        if (this.minimapTileSize % 2 == 1) {
            ++this.minimapTileSize;
        }
        this.minimapWidth = (int)(0.5f + (float)this.minimapTileSize * (float)world.getTileMap().length);
        this.minimapHeight = (int)(0.5f + (float)this.minimapTileSize * (float)world.getTileMap()[0].length);
        if (this.minimapBackground == null) {
            Pixmap mmbg = new Pixmap(this.minimapWidth + this.minimapBorderWidth * 2, this.minimapHeight + this.minimapBorderWidth * 2, Pixmap.Format.RGBA8888);
            mmbg.setColor(this.darkdarkPurple);
            mmbg.fill();
            mmbg.setColor(this.lightPurple);
            mmbg.fillRectangle(this.minimapBorderWidth, this.minimapBorderWidth, this.minimapWidth, this.minimapHeight);
            this.minimapBackground = new Texture(mmbg);
            mmbg.dispose();
        }
        this.minimapWidth += this.minimapBorderWidth * 2;
        this.minimapHeight += this.minimapBorderWidth * 2;
    }

    public void drawMinimap(WorldModel world) {
        if (this.defFloor == null) {
            this.defFloor = new DefaultFloor(new Vector2(2.0f, 2.0f), new Vector2(2.0f, 2.0f), 64, "default_floor_5");
        }
        this.mmView.update(this.getWindowWidth(), this.getWindowHeight());
        this.mmCam.update();
        this.spriteBatch.setProjectionMatrix(this.mmCam.combined);
        this.mmView.apply();
        this.spriteBatch.begin();
        this.spriteBatch.setColor(Color.WHITE);
        this.createMinimapBase(world, 0.25f);
        this.spriteBatch.draw(this.minimapBackground, (float)(this.getWindowWidth() - this.minimapWidth), 0.0f);
        this.drawMinimapTiles(world);
        this.spriteBatch.end();
    }

    public void drawMinimapTiles(WorldModel world) {
        WorldModel.TileList[][] tiles = world.getTileMap();
        WorldModel.TileList topWalls = world.topWalls;
        for (int y = 0; y < tiles[0].length; ++y) {
            for (int x = 0; x < tiles.length; ++x) {
                WorldModel.TileList tileList = tiles[x][y];
                TileObject tile = tileList.get(0);
                int i = 0;
                while (tile.getType() == GameObject.ObjectType.DEFAULTWALL && tile.isTopWall() || tile.getType() == GameObject.ObjectType.COLORWALL && tile.isTopWall()) {
                    tile = tileList.get(i++);
                }
                if (tile.getType() == GameObject.ObjectType.HOLE) {
                    this.drawMinimapTile(this.defFloor, x, y);
                }
                this.drawMinimapTile(tile, x, y);
            }
        }
        for (TileObject tile : topWalls.getTiles()) {
            float x = tile.getX();
            float y = tile.getY();
            int tileX = world.screenToBoard(x);
            int tileY = world.screenToBoard(y);
            this.drawMinimapTile(tile, tileX, tileY);
        }
    }

    public void drawMinimapTile(TileObject tile, int ix, int iy) {
        int x = this.getWindowWidth() - this.minimapWidth + ((int)(0.5f + (float)this.minimapTileSize / 2.0f + (float)this.minimapBorderWidth) + ix * this.minimapTileSize);
        int y = (int)(0.5f + (float)this.minimapTileSize / 2.0f) + this.minimapBorderWidth + iy * this.minimapTileSize;
        if (tile.getType() == GameObject.ObjectType.DOOR) {
            this.draw(((Door)tile).getDefaultDoorTexture(), Color.WHITE, 32.0f, 32.0f, (float)x, (float)y, 0.0f, this.minimapTileRatio, this.minimapTileRatio);
        } else {
            this.draw(tile.getTexture(), Color.WHITE, 32.0f, 32.0f, (float)x, (float)y, 0.0f, this.minimapTileRatio, this.minimapTileRatio);
        }
    }

    public void drawPaintIcon(WorldModel world) {
        int x = (int)(world.getPlayer().getX() * 32.0f - 35.0f);
        int y = (int)(world.getPlayer().getY() * 32.0f + 35.0f);
        this.draw(JsonAssetManager.getInstance().getEntry("paintdrop", Texture.class), Color.WHITE, 32.0f, 32.0f, (float)x, (float)y, 0.0f, 0.5f, 0.5f);
    }

    public Texture drawSign(int w, int h, int r, Color innerColor, Color outerColor, float x, float y) {
        Pixmap pixmap = new Pixmap(w, h, Pixmap.Format.RGBA8888);
        pixmap.setColor(outerColor);
        pixmap.fillCircle(w / 2, h / 2, r);
        pixmap.setColor(innerColor);
        pixmap.fillCircle(w / 2, h / 2, (int)((double)r * 0.85));
        Texture t = new Texture(pixmap);
        pixmap.dispose();
        pixmap = null;
        return t;
    }

    public Vector2 getSize() {
        return new Vector2(Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
    }

    public void setSize(int width, int height) {
        this.windowWidth = width;
        this.windowHeight = height;
        if (!this.isFullscreen()) {
            Gdx.graphics.setWindowedMode(width, height);
        }
        this.resize();
    }

    public boolean isFullscreen() {
        return Gdx.graphics.isFullscreen();
    }

    public void setFullscreen(boolean value) {
        if (value) {
            Gdx.graphics.setFullscreenMode(Gdx.graphics.getDisplayMode());
        } else {
            Gdx.graphics.setWindowedMode(this.windowWidth, this.windowHeight);
        }
    }

    public void resize() {
        this.spriteCam.setToOrtho(false, this.getWindowWidth(), this.getWindowHeight());
        this.view.update(this.getWindowWidth(), this.getWindowHeight() - 80);
    }

    public void draw(Texture image, float x, float y) {
        this.spriteBatch.setColor(Color.WHITE);
        this.spriteBatch.draw(image, x, y);
    }

    public void draw(Texture image, float x, float y, Color tint) {
        this.spriteBatch.setColor(tint);
        this.spriteBatch.draw(image, x, y);
    }

    public void draw(Texture image, float x, float y, float ox, float oy, Color tint) {
        this.spriteBatch.setColor(tint);
        this.spriteBatch.draw(image, x - ox, y - oy);
    }

    public void draw(Texture image, float x, float y, float width, float height) {
        this.spriteBatch.setColor(Color.WHITE);
        this.spriteBatch.draw(image, x, y, width, height);
    }

    public void draw(Texture image, Color tint, float ox, float oy, float x, float y, float angle, float sx, float sy) {
        this.holder.setRegion(image);
        this.draw(this.holder, tint, ox, oy, x, y, angle, sx, sy);
    }

    public void draw(Texture image, float x, float y, float ox, float oy, float width, float height) {
        this.spriteBatch.setColor(Color.WHITE);
        this.spriteBatch.draw(image, x - ox, y - oy, width, height);
    }

    public void draw(TextureRegion region, float x, float y) {
        this.spriteBatch.setColor(Color.WHITE);
        this.spriteBatch.draw(region, x, y);
    }

    public void draw(TextureRegion region, float x, float y, float width, float height) {
        this.spriteBatch.setColor(Color.WHITE);
        this.spriteBatch.draw(region, x, y, width, height);
    }

    public void draw(TextureRegion region, Color tint, float ox, float oy, float x, float y, float angle, float sx, float sy) {
        this.computeTransform(ox, oy, x, y, angle, sx, sy);
        this.spriteBatch.setColor(tint);
        this.spriteBatch.draw(region, region.getRegionWidth(), (float)region.getRegionHeight(), this.local);
    }

    private void computeTransform(float ox, float oy, float x, float y, float angle, float sx, float sy) {
        this.local.setToTranslation(x, y);
        this.local.rotate(angle);
        this.local.scale(sx, sy);
        this.local.translate(-ox, -oy);
    }

    public void drawText(String text, BitmapFont font, float x, float y) {
        GlyphLayout layout = new GlyphLayout(font, text);
        font.setColor(Color.WHITE);
        font.draw((Batch)this.spriteBatch, layout, x, y);
    }

    public void drawTextUpdate(String text, BitmapFont font, float x, float y) {
        GlyphLayout layout = new GlyphLayout(font, text);
        font.draw((Batch)this.spriteBatch, layout, x, y);
        font.setColor(Color.WHITE);
    }

    public void drawTextCentered(String text, BitmapFont font, float offset) {
        GlyphLayout layout = new GlyphLayout(font, text);
        float x = ((float)this.getWindowWidth() - layout.width) / 2.0f;
        float y = ((float)this.getWindowHeight() + layout.height) / 2.0f;
        font.setColor(Color.WHITE);
        font.draw((Batch)this.spriteBatch, layout, x, y + offset);
    }

    public void drawTransparent(Texture image, float x, float y, float ox, float oy, float width, float height, float alpha) {
        Color c = this.spriteBatch.getColor().cpy();
        this.spriteBatch.setColor(c.r, c.g, c.b, c.a * alpha);
        this.spriteBatch.draw(image, x - ox, y - oy, width, height);
        this.spriteBatch.setColor(c);
    }

    public void drawTransparent(TextureRegion region, float x, float y, float ox, float oy, float width, float height, float alpha) {
        Color c = this.spriteBatch.getColor().cpy();
        this.spriteBatch.setColor(c.r, c.g, c.b, c.a * alpha);
        this.computeTransform(ox, oy, x, y, 0.0f, 1.0f, 1.0f);
        this.spriteBatch.draw(region, region.getRegionWidth(), (float)region.getRegionHeight(), this.local);
        this.spriteBatch.setColor(c);
    }

    public int getWindowWidth() {
        return this.windowWidth;
    }

    public void setWindowWidth(int windowWidth) {
        this.windowWidth = windowWidth;
    }

    public int getWindowHeight() {
        return this.windowHeight;
    }

    public void setWindowHeight(int windowHeight) {
        this.windowHeight = windowHeight;
    }

    public void drawPlayer(int paint) {
        int size = 60;
        int centerX = this.getWindowWidth() / 2 - size / 2;
        int centerY = 40 - size / 2;
        if (InputController.paintingModePressed) {
            this.draw(this.paintingSigns[3], (float)(centerX - 8 * size), (float)centerY);
        } else {
            this.draw(this.signs[3], (float)(centerX - 8 * size), (float)centerY);
        }
        this.textFont.setColor(Color.BLACK);
        this.drawTextUpdate(Integer.toString(paint), this.textFont, (float)(centerX - 8 * size) + 1.5f * this.textFont.getXHeight(), (float)centerY + 1.25f * (float)this.fontScale * this.textFont.getXHeight());
    }
}

