/*
 * Decompiled with CFR 0.152.
 */
package com.chrominance.game;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputMultiplexer;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Dialog;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Stack;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.JsonReader;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.viewport.ScreenViewport;
import com.chrominance.game.AbstractScreen;
import com.chrominance.game.CameraShake;
import com.chrominance.game.CollisionListener;
import com.chrominance.game.DrawStatic;
import com.chrominance.game.GDXRoot;
import com.chrominance.game.GameCanvas;
import com.chrominance.game.GameplayController;
import com.chrominance.game.InputController;
import com.chrominance.game.Model.WorldModel;
import com.chrominance.game.SavedGameParser;
import com.chrominance.game.SoundController;
import com.chrominance.game.util.JsonAssetManager;

public class GameEngine
extends AbstractScreen {
    private final Stage tutorial;
    private final Stage UI;
    private CollisionListener collider;
    private GameCanvas canvas;
    private GameplayController game;
    private WorldModel world;
    public static int resetCounter;
    private CameraShake shaker;
    private final int gameScale = 32;
    private boolean active = false;
    private JsonValue levelData;
    Label.LabelStyle label1Style = new Label.LabelStyle();
    BitmapFont labelFont = new BitmapFont();
    private Dialog tutorialDialog;
    private boolean tutorialMode;
    private boolean firstTime = true;
    private final Stage death;
    private Label labelJ;
    private Label labelK;
    private Label labelL;
    private Label paintCount;
    private JsonReader jsonReader;
    private JsonValue assetDirectory;
    protected BitmapFont displayFont;
    private AssetState assetState = AssetState.EMPTY;
    private int currentLevel;
    private boolean paused = false;

    public static int getResetCounter() {
        return resetCounter;
    }

    public void preLoadContent() {
        if (this.assetState != AssetState.EMPTY) {
            return;
        }
        this.assetState = AssetState.LOADING;
        this.jsonReader = new JsonReader();
        this.assetDirectory = this.jsonReader.parse(Gdx.files.internal("jsons/assets.json"));
        JsonAssetManager.getInstance().loadDirectory(this.assetDirectory);
    }

    public void loadContent() {
        if (this.assetState != AssetState.LOADING) {
            return;
        }
        JsonAssetManager.getInstance().allocateDirectory();
        this.displayFont = JsonAssetManager.getInstance().getEntry("display", BitmapFont.class);
        this.assetState = AssetState.COMPLETE;
    }

    public void unloadContent() {
        JsonAssetManager.getInstance().unloadDirectory();
        JsonAssetManager.clearInstance();
    }

    public void initWorld() {
        this.world.setAssetDirectory(this.assetDirectory);
    }

    public GameEngine() {
        this.canvas = new GameCanvas();
        this.world = new WorldModel();
        this.game = new GameplayController(this.world);
        this.shaker = new CameraShake();
        this.tutorial = new Stage(new ScreenViewport());
        this.death = new Stage(new ScreenViewport());
        this.UI = new Stage(new ScreenViewport());
    }

    public void setLevel(int level) {
        this.currentLevel = level;
        this.levelData = this.jsonReader.parse(Gdx.files.internal(SavedGameParser.getPathToLevel(level)));
        this.reset();
        this.canvas.lookAt(32.0f * this.world.getPlayer().getX(), 32.0f * this.world.getPlayer().getY());
    }

    @Override
    public void show() {
        this.takeControl();
        if (!InputController.isUsingJKL()) {
            this.labelJ.setText("A");
            this.labelK.setText("S");
            this.labelL.setText("D");
        } else {
            this.labelJ.setText("J");
            this.labelK.setText("K");
            this.labelL.setText("L");
        }
        this.label1Style.font = this.labelFont;
        if (SavedGameParser.getTutorialText(this.currentLevel) != null && !"".equals(SavedGameParser.getTutorialText(this.currentLevel))) {
            this.tutorial.clear();
            this.tutorialDialog = new Dialog("", skin){

                @Override
                protected void result(Object object) {
                    if (((Boolean)object).booleanValue()) {
                        this.setVisible(false);
                        GameEngine.this.tutorialMode = false;
                        Gdx.input.setInputProcessor(GameEngine.this.stage);
                    }
                }
            };
            TextButton doneButton = new TextButton("Done", skin, "cyan");
            doneButton.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    GameEngine.this.tutorialDialog.setVisible(false);
                    GameEngine.this.tutorialMode = false;
                    Gdx.input.setInputProcessor(GameEngine.this.stage);
                }
            });
            this.tutorialDialog.addListener(new InputListener(){

                @Override
                public boolean keyUp(InputEvent event, int keycode) {
                    if (keycode == 66) {
                        GameEngine.this.tutorialDialog.setVisible(false);
                        GameEngine.this.tutorialMode = false;
                        Gdx.input.setInputProcessor(GameEngine.this.stage);
                        return true;
                    }
                    return false;
                }
            });
            this.tutorialDialog.setMovable(false);
            Label tutorialLabel = new Label(SavedGameParser.getTutorialText(this.currentLevel), skin, "black");
            tutorialLabel.setWrap(true);
            tutorialLabel.setHeight(20.0f);
            tutorialLabel.setAlignment(1);
            this.tutorialDialog.getContentTable().add(tutorialLabel).width(700.0f);
            if (SavedGameParser.getTutorialImage(this.currentLevel) != null && !"".equals(SavedGameParser.getTutorialImage(this.currentLevel))) {
                this.tutorialDialog.getContentTable().row();
                Image tutorialImage = new Image(JsonAssetManager.getInstance().getEntry(SavedGameParser.getTutorialImage(this.currentLevel), Texture.class));
                this.tutorialDialog.getContentTable().add(tutorialImage).pad(20.0f);
            }
            this.tutorialDialog.addActor(doneButton);
            doneButton.setY(50.0f);
            doneButton.setX(this.tutorialDialog.getPrefWidth() / 2.0f - doneButton.getPrefWidth() / 2.0f);
            this.tutorialDialog.setModal(true);
            this.tutorialDialog.show(this.tutorial);
            this.tutorialDialog.setPosition(((float)Gdx.graphics.getWidth() - this.tutorialDialog.getPrefWidth()) / 2.0f, ((float)Gdx.graphics.getHeight() - this.tutorialDialog.getPrefHeight() * 3.0f / 4.0f) / 2.0f);
            Gdx.input.setInputProcessor(new InputMultiplexer(this.tutorial, this.stage));
        }
        this.game = new GameplayController(this.world);
        InputController.enable();
    }

    private void play(float delta) {
        if (this.world.finished) {
            InputController.clear();
            this.listener.switchToScreen(GDXRoot.ScreenType.GAME, GDXRoot.ScreenType.WIN, this.currentLevel);
            SoundController.playLevelComplete();
        } else if (this.world.getPlayer().getHealth() < 1) {
            InputController.clear();
            InputController.disable();
            if (this.world.getPlayer().finishedDying()) {
                this.listener.switchToScreen(GDXRoot.ScreenType.GAME, GDXRoot.ScreenType.LOSE, this.currentLevel);
            }
        } else {
            this.world.updateWorld();
        }
        this.game.update(delta);
    }

    @Override
    public void render(float delta) {
        if (!this.paused) {
            if (!this.tutorialMode && !this.firstTime) {
                this.update(delta);
            }
            if (this.game.toShake()) {
                this.shaker = new CameraShake();
                this.shaker.shake(0.5f);
            }
            this.canvas.lookAt(32.0f * this.world.getPlayer().getX(), 32.0f * this.world.getPlayer().getY());
            this.shaker.update(delta, this.canvas.getCamera(), this.canvas.getCamera().position);
            this.draw();
            if (SavedGameParser.getTutorialText(this.currentLevel) != null && !"".equals(SavedGameParser.getTutorialText(this.currentLevel)) && this.tutorialDialog.isVisible()) {
                this.tutorialMode = true;
                this.tutorial.act(delta);
                this.tutorial.draw();
            }
            this.firstTime = false;
        } else {
            Gdx.gl.glClear(16384);
            this.draw();
            this.stage.act(delta);
            this.stage.draw();
        }
    }

    private void draw() {
        if (this.world.getPlayer().getHealth() < 1) {
            this.death.draw();
            this.canvas.begin(false);
        } else {
            this.canvas.begin(true);
        }
        this.world.draw(this.canvas);
        this.canvas.end();
        this.paintCount.setText(this.world.getPlayer().getPaint());
        this.UI.draw();
        if (InputController.isMinimapShown()) {
            this.canvas.drawMinimap(this.world);
        }
    }

    private void update(float delta) {
        InputController.readKeyboard();
        if (!this.paused && InputController.didReset()) {
            this.reset();
        }
        if (!this.paused) {
            this.play(delta);
        }
    }

    private void reset() {
        this.paused = false;
        this.game.reset();
        ++resetCounter;
        this.world = new WorldModel();
        this.world.setLevelFormat(this.levelData);
        this.world.init();
        this.game = null;
        this.game = new GameplayController(this.world);
        this.canvas.lookAt(32.0f * this.world.getPlayer().getX(), 32.0f * this.world.getPlayer().getY());
        InputController.clear();
        InputController.enable();
    }

    @Override
    public void dispose() {
        this.canvas.dispose();
        this.stage.dispose();
        this.tutorial.dispose();
        this.death.dispose();
        this.UI.dispose();
        this.canvas = null;
        this.stage = null;
        this.unloadContent();
    }

    @Override
    public void init() {
        Pixmap pixmap = new Pixmap(1, 1, Pixmap.Format.RGBA8888);
        pixmap.setColor(new Color(0.0f, 0.0f, 0.0f, 0.8f));
        pixmap.fillRectangle(0, 0, 1, 1);
        Texture texture1 = new Texture(pixmap);
        pixmap.dispose();
        Image semiTL = new Image(texture1);
        texture1.dispose();
        semiTL.setSize(Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
        semiTL.getColor().a = 0.6f;
        this.table.addActor(semiTL);
        TextButton resume = new TextButton("Resume", skin, "cyan");
        TextButton restart = new TextButton("Restart", skin, "magenta");
        TextButton menu = new TextButton("Main Menu", skin, "yellow");
        resume.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                GameEngine.this.paused = false;
            }
        });
        restart.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                GameEngine.this.reset();
            }
        });
        menu.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                GameEngine.this.listener.switchToScreen(GDXRoot.ScreenType.GAME, GDXRoot.ScreenType.MENU, 0);
            }
        });
        this.stage.addListener(new InputListener(){

            @Override
            public boolean keyDown(InputEvent e, int key) {
                if (key == 131) {
                    GameEngine.this.paused = !GameEngine.this.paused;
                    if (GameEngine.this.world.getPlayer().getHealth() < 1) {
                        GameEngine.this.paused = false;
                    }
                    return true;
                }
                return false;
            }
        });
        this.table.add(resume);
        this.table.row().pad(20.0f, 0.0f, 20.0f, 0.0f);
        this.table.add(restart);
        this.table.row();
        this.table.add(menu);
        Table dTable = new Table();
        dTable.setFillParent(true);
        this.death.addActor(dTable);
        dTable.setBackground(DrawStatic.getInstance());
        Image colorCyan = new Image(skin, "cyan_button");
        this.labelJ = new Label((CharSequence)"J", skin);
        this.labelJ.setAlignment(1, 1);
        Stack cyanUI = new Stack(colorCyan, this.labelJ);
        Image colorMagenta = new Image(skin, "magenta_button");
        this.labelK = new Label((CharSequence)"K", skin);
        this.labelK.setAlignment(1, 1);
        Stack magentaUI = new Stack(colorMagenta, this.labelK);
        Image colorYellow = new Image(skin, "yellow_button");
        this.labelL = new Label((CharSequence)"L", skin);
        this.labelL.setAlignment(1, 1);
        Stack yellowUI = new Stack(colorYellow, this.labelL);
        Image paintBack = new Image(skin, "paint_number_display");
        this.paintCount = new Label((CharSequence)"0", skin);
        this.paintCount.setAlignment(1, 1);
        Stack paintUI = new Stack(paintBack, this.paintCount);
        Image paintDrop = new Image(JsonAssetManager.getInstance().getEntry("paintdrop", Texture.class));
        Pixmap uibg = new Pixmap(Gdx.graphics.getWidth(), 80, Pixmap.Format.RGBA8888);
        uibg.setColor(GameCanvas.darkPurple);
        uibg.fill();
        Texture t = new Texture(uibg);
        uibg.dispose();
        Image uiBackground = new Image(t);
        this.UI.addActor(uiBackground);
        this.UI.addActor(paintDrop);
        paintDrop.setPosition(20.0f, 10.0f);
        this.UI.addActor(paintUI);
        paintUI.setPosition(90.0f, 10.0f);
        paintUI.setSize(60.0f, 60.0f);
        this.UI.addActor(cyanUI);
        cyanUI.setPosition(Gdx.graphics.getWidth() * 2 / 6, 10.0f);
        cyanUI.setSize(60.0f, 60.0f);
        this.UI.addActor(magentaUI);
        magentaUI.setPosition(Gdx.graphics.getWidth() * 3 / 6, 10.0f);
        magentaUI.setSize(60.0f, 60.0f);
        this.UI.addActor(yellowUI);
        yellowUI.setPosition(Gdx.graphics.getWidth() * 4 / 6, 10.0f);
        yellowUI.setSize(60.0f, 60.0f);
    }

    protected static enum AssetState {
        EMPTY,
        LOADING,
        COMPLETE;

    }
}

