/*
 * Decompiled with CFR 0.152.
 */
package com.chrominance.game;

import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.World;
import com.badlogic.gdx.utils.Array;
import com.chrominance.game.AIController;
import com.chrominance.game.GameEngine;
import com.chrominance.game.InputController;
import com.chrominance.game.Model.ColorWall;
import com.chrominance.game.Model.GameObject;
import com.chrominance.game.Model.GarbageCollector;
import com.chrominance.game.Model.Player;
import com.chrominance.game.Model.TileObject;
import com.chrominance.game.Model.WorldModel;
import com.chrominance.game.SoundController;
import com.chrominance.game.util.FilmStrip;
import com.chrominance.game.util.JsonAssetManager;
import java.util.ArrayList;

public class GameplayController {
    private WorldModel worldModel;
    private World world;
    private ArrayList<AIController> aiControllers;
    private boolean colorChanged;
    float animFrame = 0.0f;
    int NUM_ANIM_FRAMES = 9;
    float ANIMATION_SPEED = 0.3f;
    FilmStrip paintingCyan = (FilmStrip)JsonAssetManager.getInstance().getEntry("painting_cyan", TextureRegion.class);
    FilmStrip paintingMagenta = (FilmStrip)JsonAssetManager.getInstance().getEntry("painting_magenta", TextureRegion.class);
    FilmStrip paintingYellow = (FilmStrip)JsonAssetManager.getInstance().getEntry("painting_yellow", TextureRegion.class);

    public GameplayController(WorldModel worldModel) {
        this.worldModel = worldModel;
        this.world = worldModel.getWorld();
        Array<GarbageCollector> garbageCollectors = worldModel.getGarbageCollectors();
        this.aiControllers = new ArrayList();
        for (int i = 0; i < garbageCollectors.size; ++i) {
            this.aiControllers.add(new AIController(garbageCollectors.get(i), worldModel));
        }
    }

    public boolean toShake() {
        if (this.worldModel.getPlayer().getHealth() > 0) {
            return this.colorChanged;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void update(float deltaTime) {
        Player player = this.worldModel.getPlayer();
        if (player.getHealth() >= 1) {
            int i;
            this.colorChanged = false;
            if (InputController.didSwitchToFullColor()) {
                this.colorChanged = this.worldModel.getColorMode() != GameObject.ColorMode.NONE;
                this.worldModel.setWorldColor(GameObject.ColorMode.NONE);
            } else if (InputController.didSwitchToCyan()) {
                this.colorChanged = this.worldModel.getColorMode() != GameObject.ColorMode.CYAN;
                this.worldModel.setWorldColor(GameObject.ColorMode.CYAN);
                SoundController.playModeSwitch();
            } else if (InputController.didSwitchToMagenta()) {
                this.colorChanged = this.worldModel.getColorMode() != GameObject.ColorMode.MAGENTA;
                this.worldModel.setWorldColor(GameObject.ColorMode.MAGENTA);
                SoundController.playModeSwitch();
            } else if (InputController.didSwitchToYellow()) {
                this.colorChanged = this.worldModel.getColorMode() != GameObject.ColorMode.YELLOW;
                this.worldModel.setWorldColor(GameObject.ColorMode.YELLOW);
                SoundController.playModeSwitch();
            }
            if (InputController.didPaintCyan()) {
                SoundController.playPaintPoof();
                this.worldModel.paintTiles(GameObject.ColorMode.CYAN);
                this.worldModel.painting = this.paintingCyan;
                InputController.softClear();
            } else if (InputController.didPaintMagenta()) {
                SoundController.playPaintPoof();
                this.worldModel.paintTiles(GameObject.ColorMode.MAGENTA);
                this.worldModel.painting = this.paintingMagenta;
                InputController.softClear();
            } else if (InputController.didPaintYellow()) {
                SoundController.playPaintPoof();
                this.worldModel.paintTiles(GameObject.ColorMode.YELLOW);
                this.worldModel.painting = this.paintingYellow;
                InputController.softClear();
            }
            if (this.colorChanged) {
                Vector2 playerPosition = player.getPosition();
                int playerX = this.worldModel.screenToBoard(playerPosition.x);
                int playerY = this.worldModel.screenToBoard(playerPosition.y);
                WorldModel.TileList playerTileList = this.worldModel.getTileMap()[playerX][playerY];
                for (TileObject tile : playerTileList) {
                    ColorWall cw;
                    block31: {
                        if (!(tile instanceof ColorWall) || tile.getColorMode() == this.worldModel.getColorMode()) continue;
                        cw = (ColorWall)tile;
                        if (cw.isHalfWall()) {
                            float hbHeight = player.getDimension().y / 2.0f;
                            float hbOriginY = (player.getHbOrigin().y - hbHeight) / Player.gameScale;
                            if (cw.isTopWall) {
                                if (this.worldModel.screenToBoard(playerPosition.y + hbOriginY - hbHeight / Player.gameScale) == this.worldModel.screenToBoard(playerPosition.y + hbOriginY)) {
                                    if (playerTileList.getSize() > 1 && playerTileList.get(1).getType() == GameObject.ObjectType.COLORWALL) {
                                        ColorWall cw2 = (ColorWall)playerTileList.get(1);
                                        if (this.worldModel.screenToBoard(playerPosition.y + hbOriginY - hbHeight / Player.gameScale) == this.worldModel.screenToBoard(cw2.getY())) {
                                            player.updateHealth(-100);
                                            SoundController.playPlayerDeath();
                                            break;
                                        }
                                        player.getBody().applyLinearImpulse(0.0f, -40.0f, 0.0f, 0.0f, true);
                                        break;
                                    }
                                    break block31;
                                } else {
                                    player.updateHealth(-100);
                                    SoundController.playPlayerDeath();
                                    break;
                                }
                            }
                            if (this.worldModel.screenToBoard(playerPosition.y + hbOriginY - hbHeight / Player.gameScale) == this.worldModel.screenToBoard(cw.getY())) {
                                player.updateHealth(-100);
                                SoundController.playPlayerDeath();
                                break;
                            }
                            player.getBody().applyLinearImpulse(0.0f, -40.0f, 0.0f, 0.0f, true);
                            break;
                        }
                    }
                    if (cw.isTopWall) continue;
                    player.updateHealth(-100);
                    SoundController.playPlayerDeath();
                    break;
                }
            }
            for (i = 0; i < this.aiControllers.size(); ++i) {
                AIController aiController = this.aiControllers.get(i);
                GarbageCollector garbageCollector = aiController.getGarbageCollector();
                if (garbageCollector.isDirty()) {
                    this.aiControllers.remove(aiController);
                    this.worldModel.getGarbageCollectors().removeValue(garbageCollector, true);
                    garbageCollector.deactivatePhysics(this.world);
                    continue;
                }
                aiController.update(deltaTime);
            }
            i = 0;
            while (true) {
                if (i < this.worldModel.getWidth()) {
                } else {
                    this.world.step(deltaTime, 6, 2);
                    break;
                }
                for (int j = 0; j < this.worldModel.getHeight(); ++j) {
                    for (TileObject tile : this.worldModel.getTileMap()[i][j]) {
                        if (!tile.isDirty()) continue;
                        Vector2 holePos = tile.getPosition();
                        int holeX = this.worldModel.screenToBoard(holePos.x);
                        int holeY = this.worldModel.screenToBoard(holePos.y);
                        this.worldModel.removeTile(tile, holeX, holeY);
                        tile.deactivatePhysics(this.world);
                        tile = null;
                    }
                }
                ++i;
            }
        }
        this.worldModel.getPlayer().update(deltaTime);
        if (this.worldModel.isPainting) {
            this.animFrame += this.ANIMATION_SPEED;
            if (this.animFrame >= (float)this.NUM_ANIM_FRAMES) {
                this.worldModel.isPainting = false;
                this.animFrame = 0.0f;
            }
            this.worldModel.painting.setFrame((int)this.animFrame);
        }
    }

    public void reset() {
        int i;
        for (i = 0; i < this.worldModel.getWidth(); ++i) {
            for (int j = 0; j < this.worldModel.getHeight(); ++j) {
                for (TileObject tile : this.worldModel.getTileMap()[i][j]) {
                    tile.deactivatePhysics(this.world);
                }
            }
        }
        for (i = 0; i < this.aiControllers.size(); ++i) {
            AIController aiController = this.aiControllers.get(i);
            GarbageCollector garbageCollector = aiController.getGarbageCollector();
            garbageCollector.removeSensor();
            garbageCollector.deactivatePhysics(this.world);
            garbageCollector = null;
            Object var2_4 = null;
        }
        this.aiControllers = null;
        if (this.worldModel.getPlayer() != null) {
            this.worldModel.getPlayer().deactivatePhysics(this.world);
            this.worldModel.reset();
            this.worldModel = null;
            this.world.dispose();
            this.world = null;
        }
        if (GameEngine.getResetCounter() % 4 == 0) {
            System.gc();
        }
    }
}

