/*
 * Decompiled with CFR 0.152.
 */
package com.chrominance.game;

import com.badlogic.gdx.Gdx;

public class InputController {
    protected static boolean resetPressed;
    private static boolean useJKL;
    private static int cyanKey;
    private static int magentaKey;
    private static int yellowKey;
    private static boolean useWASD;
    private static int upKey;
    private static int leftKey;
    private static int downKey;
    private static int rightKey;
    private static final int COOLDOWN = 15;
    private static int lastColorPressed;
    protected static int cooldown;
    private static boolean playerHasPaint;
    protected static boolean cyanPressed;
    protected static boolean magentaPressed;
    protected static boolean yellowPressed;
    protected static boolean fullColorPressed;
    public static boolean paintingModePressed;
    protected static boolean yellowPaintPressed;
    protected static boolean cyanPaintPressed;
    protected static boolean magentaPaintPressed;
    private static int horizontalMovement;
    private static int verticalMovement;
    private static boolean showMinimap;
    private static boolean enabled;

    public static boolean isUsingJKL() {
        return useJKL;
    }

    public static boolean isUsingWASD() {
        return useWASD;
    }

    public static void setColorKeys(boolean useJKL) {
        InputController.useJKL = useJKL;
        cyanKey = useJKL ? 38 : 29;
        magentaKey = useJKL ? 39 : 47;
        yellowKey = useJKL ? 40 : 32;
    }

    public static void setMovementKeys(boolean useWASD) {
        InputController.useWASD = useWASD;
        upKey = useWASD ? 51 : 19;
        leftKey = useWASD ? 29 : 21;
        downKey = useWASD ? 47 : 20;
        rightKey = useWASD ? 32 : 22;
    }

    public static void setPlayerHasPaint(boolean hasPaint) {
        playerHasPaint = hasPaint;
    }

    public static int getMaxCooldown() {
        return 15;
    }

    public static boolean isMinimapShown() {
        return enabled && showMinimap;
    }

    public static boolean didReset() {
        return resetPressed;
    }

    public static boolean didSwitchToCyan() {
        return enabled && cyanPressed;
    }

    public static boolean didSwitchToMagenta() {
        return enabled && magentaPressed;
    }

    public static boolean didSwitchToYellow() {
        return enabled && yellowPressed;
    }

    public static boolean didSwitchToFullColor() {
        return enabled && fullColorPressed;
    }

    public static boolean didPaintCyan() {
        return enabled && cyanPaintPressed;
    }

    public static boolean didPaintMagenta() {
        return enabled && magentaPaintPressed;
    }

    public static boolean didPaintYellow() {
        return enabled && yellowPaintPressed;
    }

    public static int getHorizontalMovement() {
        return horizontalMovement;
    }

    public static int getVerticalMovement() {
        return verticalMovement;
    }

    public static void clear() {
        resetPressed = false;
        cyanPressed = false;
        magentaPressed = false;
        yellowPressed = false;
        fullColorPressed = false;
        cyanPaintPressed = false;
        magentaPaintPressed = false;
        yellowPaintPressed = false;
        paintingModePressed = false;
        lastColorPressed = 46;
        playerHasPaint = false;
    }

    public static void softClear() {
        resetPressed = false;
        cyanPressed = false;
        magentaPressed = false;
        yellowPressed = false;
        fullColorPressed = false;
        cyanPaintPressed = false;
        magentaPaintPressed = false;
        yellowPaintPressed = false;
        paintingModePressed = false;
    }

    public static void readKeyboard() {
        resetPressed = Gdx.input.isKeyJustPressed(46);
        paintingModePressed = playerHasPaint && (Gdx.input.isKeyPressed(59) || Gdx.input.isKeyPressed(60));
        if (--cooldown <= 0) {
            if (paintingModePressed) {
                cyanPaintPressed = Gdx.input.isKeyJustPressed(cyanKey);
                magentaPaintPressed = Gdx.input.isKeyJustPressed(magentaKey);
                yellowPaintPressed = Gdx.input.isKeyJustPressed(yellowKey);
                boolean bl = paintingModePressed = !cyanPaintPressed && !magentaPaintPressed && !yellowPaintPressed;
                if (!paintingModePressed && enabled) {
                    cooldown = 15;
                }
            } else {
                cyanPressed = Gdx.input.isKeyJustPressed(cyanKey) ^ cyanPressed && !cyanPressed;
                magentaPressed = Gdx.input.isKeyJustPressed(magentaKey) ^ magentaPressed && !magentaPressed;
                yellowPressed = Gdx.input.isKeyJustPressed(yellowKey) ^ yellowPressed && !yellowPressed;
                boolean bl = fullColorPressed = cyanPressed && lastColorPressed == cyanKey || magentaPressed && lastColorPressed == magentaKey || yellowPressed && lastColorPressed == yellowKey;
                if (enabled) {
                    if (cyanPressed || magentaPressed || yellowPressed || fullColorPressed) {
                        cooldown = 15;
                    }
                    if (cyanPressed) {
                        lastColorPressed = cyanKey;
                    }
                    if (magentaPressed) {
                        lastColorPressed = magentaKey;
                    }
                    if (yellowPressed) {
                        lastColorPressed = yellowKey;
                    }
                    if (fullColorPressed) {
                        lastColorPressed = 46;
                        cyanPressed = false;
                        magentaPressed = false;
                        yellowPressed = false;
                    }
                }
            }
        }
        horizontalMovement = Gdx.input.isKeyPressed(rightKey) ? 1 : (Gdx.input.isKeyPressed(leftKey) ? -1 : 0);
        verticalMovement = Gdx.input.isKeyPressed(upKey) ? 1 : (Gdx.input.isKeyPressed(downKey) ? -1 : 0);
        showMinimap = Gdx.input.isKeyPressed(61);
    }

    public static void disable() {
        enabled = false;
    }

    public static void enable() {
        enabled = true;
    }

    static {
        useJKL = true;
        cyanKey = 38;
        magentaKey = 39;
        yellowKey = 40;
        useWASD = true;
        upKey = 51;
        leftKey = 29;
        downKey = 47;
        rightKey = 32;
        lastColorPressed = 46;
    }
}

