/*
 * Decompiled with CFR 0.152.
 */
package com.chrominance.game;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.HorizontalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.SnapshotArray;
import com.chrominance.game.AbstractScreen;
import com.chrominance.game.GDXRoot;
import com.chrominance.game.SavedGameParser;

public class LevelScreen
extends AbstractScreen {
    private static final int COLUMNS = 5;
    private static final int ROWS = 3;
    private final HorizontalGroup scrollTable = new HorizontalGroup();

    @Override
    public void show() {
        this.takeControl();
        int counter = 0;
        boolean[] levelsUnlocked = SavedGameParser.getLevelsUnlocked();
        for (Actor page : this.scrollTable.getChildren()) {
            if (!(page instanceof Table)) continue;
            for (Actor b : ((Table)page).getChildren()) {
                if (!(b instanceof TextButton) || counter >= levelsUnlocked.length) continue;
                ((TextButton)b).setDisabled(!levelsUnlocked[counter]);
                ++counter;
            }
        }
    }

    @Override
    public void init() {
        boolean[] levelsUnlocked = SavedGameParser.getLevelsUnlocked();
        int numLevels = levelsUnlocked.length;
        final ScrollPane scroll = new ScrollPane((Actor)this.scrollTable, skin);
        scroll.setScrollBarTouch(false);
        scroll.setScrollbarsVisible(false);
        scroll.setClamp(true);
        scroll.setFadeScrollBars(true);
        scroll.setFlickScroll(false);
        scroll.clearListeners();
        Table page = new Table();
        page.setWidth(Gdx.graphics.getWidth());
        page.pad(0.0f, 75.0f, 0.0f, 75.0f);
        int rowCounter = 1;
        boolean justAdded = false;
        for (int i = 0; i < numLevels; ++i) {
            justAdded = false;
            TextButton button = new TextButton(Integer.toString(i), skin, "level");
            final int l = i;
            button.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    LevelScreen.this.listener.switchToScreen(GDXRoot.ScreenType.LEVELS, GDXRoot.ScreenType.GAME, l);
                }
            });
            if (levelsUnlocked[i]) {
                button.setDisabled(false);
            } else {
                button.setDisabled(true);
            }
            page.add(button).pad(20.0f);
            if ((i + 1) % 5 == 0) {
                page.row();
                ++rowCounter;
            }
            if (rowCounter % 4 != 0) continue;
            this.scrollTable.addActor(page);
            this.scrollTable.expand().fill();
            rowCounter = 1;
            page = new Table();
            page.setWidth(Gdx.graphics.getWidth());
            page.pad(0.0f, 75.0f, 0.0f, 75.0f);
            justAdded = true;
        }
        if (!justAdded) {
            int numLast = numLevels % 15;
            if (numLast != 0) {
                for (int i = numLevels % 5; i < 15 - numLast + numLevels % 5; ++i) {
                    TextButton button = new TextButton(Integer.toString(-1), skin, "level");
                    page.add(button).pad(20.0f);
                    if ((i + 1) % 5 == 0) {
                        page.row();
                    }
                    button.setVisible(false);
                }
            }
            this.scrollTable.addActor(page);
            this.scrollTable.expand().fill();
        }
        this.table.add(scroll).colspan(5).expand().fill().pad(0.0f, 100.0f, 0.0f, 100.0f);
        if (this.scrollTable.getChildren().size > 1) {
            this.table.row().pad(10.0f);
            final TextButton prevPage = new TextButton("Prev", skin, "cyan");
            prevPage.setDisabled(true);
            final TextButton nextPage = new TextButton("Next", skin, "cyan");
            prevPage.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    float scrollX = scroll.getScrollX();
                    SnapshotArray<Actor> pages = LevelScreen.this.scrollTable.getChildren();
                    float pageX = 0.0f;
                    float pageWidth = 0.0f;
                    int currentPage = -1;
                    if (pages.size > 0) {
                        for (Actor a : pages) {
                            ++currentPage;
                            pageX = a.getX();
                            if (!((double)scrollX < (double)pageX + (double)(pageWidth = a.getWidth()) * 0.5)) continue;
                            break;
                        }
                        if (currentPage != 0) {
                            scroll.scrollTo((float)(currentPage - 1) * pageWidth, 0.0f, pageWidth, scroll.getHeight(), true, true);
                            nextPage.setDisabled(false);
                        }
                        if (currentPage - 1 == 0) {
                            prevPage.setDisabled(true);
                        }
                    }
                }
            });
            nextPage.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    float scrollX = scroll.getScrollX();
                    SnapshotArray<Actor> pages = LevelScreen.this.scrollTable.getChildren();
                    float pageX = 0.0f;
                    float pageWidth = 0.0f;
                    int currentPage = -1;
                    if (pages.size > 0) {
                        for (Actor a : pages) {
                            ++currentPage;
                            pageX = a.getX();
                            if (!((double)scrollX < (double)pageX + (double)(pageWidth = a.getWidth()) * 0.5)) continue;
                            break;
                        }
                        if (currentPage != pages.size - 1) {
                            scroll.scrollTo((float)(currentPage + 1) * pageWidth, 0.0f, pageWidth, scroll.getHeight(), true, true);
                            prevPage.setDisabled(false);
                        }
                        if (currentPage + 1 == pages.size - 1) {
                            nextPage.setDisabled(true);
                        }
                    }
                }
            });
            HorizontalGroup arrows = new HorizontalGroup();
            arrows.addActor(prevPage);
            arrows.addActor(nextPage);
            this.table.add(arrows).colspan(5);
        }
        this.table.row().pad(30.0f);
        TextButton back = new TextButton("Back", skin, "cyan");
        back.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                LevelScreen.this.listener.switchToScreen(GDXRoot.ScreenType.LEVELS, GDXRoot.ScreenType.MENU, 0);
            }
        });
        this.table.add(back).colspan(5);
        this.table.setBackground(skin.getDrawable("background"));
    }
}

