/*
 * Decompiled with CFR 0.152.
 */
package com.chrominance.game;

import com.badlogic.gdx.Screen;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.chrominance.game.GDXRoot;
import com.chrominance.game.GameCanvas;
import com.chrominance.game.util.JsonAssetManager;
import com.chrominance.game.util.ScreenListener;

public class LoadingScreen
implements Screen {
    private static float DELAY = 1.0f;
    private GameCanvas canvas;
    private AssetManager loader = JsonAssetManager.getInstance();
    private float progress = 0.0f;
    private float progressState = 0.0f;
    private int budget;
    private boolean active = true;
    private float timeElapsed = 0.0f;
    private ScreenListener listener;

    public LoadingScreen() {
        this.canvas = new GameCanvas();
    }

    private void update(float delta) {
        this.loader.update(this.budget);
        this.progress = this.loader.getProgress();
        if (this.progress >= 1.0f) {
            this.progress = 1.0f;
            this.timeElapsed += delta;
        }
    }

    private void draw() {
        this.canvas.begin();
        this.canvas.drawText("Loading Progress: " + this.progress * 100.0f + "%", new BitmapFont(), 100.0f, 100.0f);
        this.canvas.end();
    }

    @Override
    public void show() {
        this.active = true;
    }

    @Override
    public void render(float delta) {
        if (this.active) {
            this.update(delta);
            this.draw();
            if (this.progress >= 1.0f && this.timeElapsed >= DELAY) {
                this.listener.switchToScreen(GDXRoot.ScreenType.LOAD, GDXRoot.ScreenType.MENU, 0);
            }
        }
    }

    @Override
    public void resize(int width, int height) {
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void hide() {
        this.active = false;
    }

    @Override
    public void dispose() {
    }

    public void setScreenListener(ScreenListener listener) {
        this.listener = listener;
    }
}

