/*
 * Decompiled with CFR 0.152.
 */
package com.chrominance.game;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.chrominance.game.AbstractScreen;
import com.chrominance.game.DrawStatic;
import com.chrominance.game.GDXRoot;

public class LoseScreen
extends AbstractScreen {
    private int level;
    private Label loseText2;

    @Override
    public void init() {
        Label loseText1 = new Label((CharSequence)"Error 404: Life not found", skin);
        this.loseText2 = new Label((CharSequence)"", skin);
        TextButton menu = new TextButton("Back to Menu", skin, "magenta");
        TextButton restart = new TextButton("Restart", skin, "magenta");
        this.stage.setKeyboardFocus(this.table);
        menu.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                LoseScreen.this.listener.switchToScreen(GDXRoot.ScreenType.LOSE, GDXRoot.ScreenType.MENU, 0);
            }
        });
        restart.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                LoseScreen.this.listener.switchToScreen(GDXRoot.ScreenType.LOSE, GDXRoot.ScreenType.GAME, LoseScreen.this.level);
            }
        });
        this.table.setBackground(DrawStatic.getInstance());
        this.table.add(loseText1).colspan(2);
        this.table.row();
        this.table.add(this.loseText2).colspan(2);
        this.table.row().pad(50.0f, 0.0f, 0.0f, 0.0f);
        this.table.add(menu).padRight(50.0f);
        this.table.add(restart).padLeft(50.0f);
        this.table.addListener(new InputListener(){

            @Override
            public boolean keyUp(InputEvent event, int keycode) {
                if (event.getKeyCode() == 66) {
                    LoseScreen.this.listener.switchToScreen(GDXRoot.ScreenType.LOSE, GDXRoot.ScreenType.GAME, LoseScreen.this.level);
                    return true;
                }
                return false;
            }
        });
    }

    @Override
    public void show() {
        this.takeControl();
        this.stage.setKeyboardFocus(this.table);
        this.loseText2.setText("Level " + this.level + " failed");
    }

    @Override
    public void dispose() {
        this.stage.dispose();
    }

    public void setLevel(int level) {
        this.level = level;
    }
}

