/*
 * Decompiled with CFR 0.152.
 */
package com.chrominance.game.Model;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.BodyDef;
import com.badlogic.gdx.physics.box2d.Filter;
import com.badlogic.gdx.physics.box2d.Fixture;
import com.chrominance.game.Model.GameObject;
import com.chrominance.game.Model.TileObject;
import com.chrominance.game.util.JsonAssetManager;

public class ColorWall
extends TileObject {
    public boolean isTopWall;
    public boolean isBotWall;
    public boolean priority;

    @Override
    public GameObject.ObjectType getType() {
        return GameObject.ObjectType.COLORWALL;
    }

    @Override
    public boolean isActive(GameObject.ColorMode worldColorMode) {
        if (this.colorMode == GameObject.ColorMode.NONE) {
            return true;
        }
        return worldColorMode != this.getColorMode();
    }

    @Override
    public void setFilterData(Filter value) {
        super.setFilterData(value);
        if (this.body != null) {
            for (Fixture f : this.body.getFixtureList()) {
                f.setFilterData(value);
            }
        }
    }

    @Override
    public void switchColorMode(GameObject.ColorMode c, boolean isPainting) {
        if (isPainting) {
            String cString = this.getStringFromColorMode(this.colorMode);
            this.colorMode = c;
            switch (c) {
                case NONE: {
                    break;
                }
                case CYAN: {
                    this.setTexture(JsonAssetManager.getInstance().getEntry(this.getTextureKey().replace(cString, "cyan"), Texture.class));
                    break;
                }
                case MAGENTA: {
                    this.setTexture(JsonAssetManager.getInstance().getEntry(this.getTextureKey().replace(cString, "magenta"), Texture.class));
                    break;
                }
                case YELLOW: {
                    this.setTexture(JsonAssetManager.getInstance().getEntry(this.getTextureKey().replace(cString, "yellow"), Texture.class));
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
    }

    public ColorWall(Vector2 screenPos, Vector2 hBox, float ox, float oy, GameObject.ColorMode objColor, String key, TileObject.WallType type) {
        super(screenPos.x, screenPos.y, hBox.x, hBox.y, ox, oy);
        this.setDensity(0.0f);
        this.setFriction(0.0f);
        this.setRestitution(0.0f);
        this.setColorMode(objColor);
        this.setTextureKey(key);
        this.switchColorMode(objColor, true);
        this.setBodyType(BodyDef.BodyType.StaticBody);
        this.isTopWall = type == TileObject.WallType.TOP;
        this.isBotWall = type == TileObject.WallType.BOT;
        this.priority = true;
    }

    public boolean isHalfWall() {
        return this.isTopWall || this.isBotWall;
    }

    @Override
    public boolean isTopWall() {
        return this.isTopWall;
    }

    public void setPriority(boolean p) {
        this.priority = p;
    }
}

