/*
 * Decompiled with CFR 0.152.
 */
package com.chrominance.game.Model;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.BodyDef;
import com.chrominance.game.GameCanvas;
import com.chrominance.game.Model.GameObject;
import com.chrominance.game.Model.TileObject;
import com.chrominance.game.util.JsonAssetManager;

public class DefaultFloor
extends TileObject {
    @Override
    public GameObject.ObjectType getType() {
        return GameObject.ObjectType.DEFAULTFLOOR;
    }

    @Override
    public boolean isActive(GameObject.ColorMode c) {
        return true;
    }

    @Override
    public void switchColorMode(GameObject.ColorMode c, boolean isPainting) {
        switch (c) {
            case NONE: {
                this.setTexture(JsonAssetManager.getInstance().getEntry(this.getTextureKey(), Texture.class));
                break;
            }
            case CYAN: {
                this.setTexture(JsonAssetManager.getInstance().getEntry(this.getTextureKey().replace("default", "cyan"), Texture.class));
                break;
            }
            case MAGENTA: {
                this.setTexture(JsonAssetManager.getInstance().getEntry(this.getTextureKey().replace("default", "magenta"), Texture.class));
                break;
            }
            case YELLOW: {
                this.setTexture(JsonAssetManager.getInstance().getEntry(this.getTextureKey().replace("default", "yellow"), Texture.class));
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public void draw(GameCanvas canvas) {
        super.draw(canvas);
    }

    public DefaultFloor(Vector2 screenPos, Vector2 hBox, int size, String key) {
        super(screenPos.x, screenPos.y, size, size);
        this.colorMode = GameObject.ColorMode.NONE;
        this.setBodyType(BodyDef.BodyType.StaticBody);
        this.setDensity(0.0f);
        this.setFriction(0.0f);
        this.setRestitution(0.0f);
        this.setName(key);
        this.setTextureKey(key);
        this.setTexture(JsonAssetManager.getInstance().getEntry(key, Texture.class));
    }
}

