/*
 * Decompiled with CFR 0.152.
 */
package com.chrominance.game.Model;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.BodyDef;
import com.chrominance.game.Model.GameObject;
import com.chrominance.game.Model.TileObject;
import com.chrominance.game.util.JsonAssetManager;

public class DefaultWall
extends TileObject {
    public boolean isTopWall;
    public boolean isBotWall;

    public DefaultWall(Vector2 screenPos, Vector2 hBox, int size, String key) {
        super(screenPos.x, screenPos.y, hBox.x, hBox.y);
        this.colorMode = GameObject.ColorMode.NONE;
        this.setDensity(0.0f);
        this.setFriction(0.0f);
        this.setRestitution(0.0f);
        this.setName(key);
        this.setTextureKey(key);
        this.setBodyType(BodyDef.BodyType.StaticBody);
        Texture t = JsonAssetManager.getInstance().getEntry(this.getTextureKey(), Texture.class);
        this.setTexture(t);
        this.isTopWall = false;
        this.isBotWall = false;
    }

    public DefaultWall(Vector2 screenPos, Vector2 hBox, float ox, float oy, String key, TileObject.WallType type) {
        super(screenPos.x, screenPos.y, hBox.x, hBox.y, ox, oy);
        this.colorMode = GameObject.ColorMode.NONE;
        this.setDensity(0.0f);
        this.setFriction(0.0f);
        this.setRestitution(0.0f);
        this.setName(key);
        this.setTextureKey(key);
        this.setBodyType(BodyDef.BodyType.StaticBody);
        Texture t = JsonAssetManager.getInstance().getEntry(this.getTextureKey(), Texture.class);
        this.setTexture(t);
        this.isTopWall = type == TileObject.WallType.TOP;
        this.isBotWall = type == TileObject.WallType.BOT;
    }

    @Override
    public void switchColorMode(GameObject.ColorMode cmode, boolean isPainting) {
    }

    @Override
    public GameObject.ObjectType getType() {
        return GameObject.ObjectType.DEFAULTWALL;
    }

    @Override
    public boolean isActive(GameObject.ColorMode c) {
        return true;
    }

    public boolean isHalfWall() {
        return this.isTopWall || this.isBotWall;
    }

    @Override
    public boolean isTopWall() {
        return this.isTopWall;
    }
}

