/*
 * Decompiled with CFR 0.152.
 */
package com.chrominance.game.Model;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.BodyDef;
import com.badlogic.gdx.physics.box2d.ChainShape;
import com.chrominance.game.GameCanvas;
import com.chrominance.game.Model.GameObject;
import com.chrominance.game.Model.TileObject;
import com.chrominance.game.Model.WorldModel;
import com.chrominance.game.util.FilmStrip;
import com.chrominance.game.util.JsonAssetManager;

public class Door
extends TileObject {
    private int setid = 0;
    private boolean opened = false;
    private FilmStrip lights;
    private static final float ANIMATION_SPEED = 0.05f;
    private float animFrame;
    private Texture defaultTexture;

    public Door(float x, float y) {
        super(x, y);
    }

    public Door(Vector2 screenPos, Vector2 hBox, int size, GameObject.ColorMode objColor, String key, int setId) {
        super(screenPos.x, screenPos.y);
        this.setid = setId;
        this.dimension = new Vector2(hBox.x, hBox.y);
        this.sizeCache = new Vector2();
        this.shape = new ChainShape();
        this.vertices = new float[8];
        this.geometry = null;
        this.origin = new Vector2(32.0f, 32.0f);
        this.resize(hBox.x, hBox.y);
        this.defaultTexture = JsonAssetManager.getInstance().getEntry("door", Texture.class);
        this.setBodyType(BodyDef.BodyType.StaticBody);
    }

    public Texture getDefaultDoorTexture() {
        return this.defaultTexture;
    }

    public void setOpened(boolean val) {
        this.opened = val;
    }

    public void updateGateTextureToGates() {
        int setSize = WorldModel.getPressureSet((int)this.setid).size;
        this.lights = (FilmStrip)JsonAssetManager.getInstance().getEntry(Integer.toString(setSize) + "_gate", TextureRegion.class);
        this.animFrame = 0.0f;
    }

    @Override
    public void draw(GameCanvas canvas) {
        this.lights.setFrame((int)this.animFrame);
        canvas.draw(this.lights, Color.WHITE, this.origin.x, this.origin.y, this.getX() * gameScale, this.getY() * gameScale, 0.0f, 1.0f, 1.0f);
    }

    public void updateGate(int num) {
        this.animFrame = num;
    }

    public void decGate() {
        this.animFrame -= 1.0f;
    }

    @Override
    public void switchColorMode(GameObject.ColorMode cmode, boolean isPainting) {
    }

    public boolean getOpened() {
        return this.opened;
    }

    private void resize(float width, float height) {
        this.vertices[0] = -width / 2.0f;
        this.vertices[1] = -height / 2.0f;
        this.vertices[2] = -width / 2.0f;
        this.vertices[3] = 0.0f;
        this.vertices[4] = width / 2.0f;
        this.vertices[5] = 0.0f;
        this.vertices[6] = width / 2.0f;
        this.vertices[7] = -height / 2.0f;
        ((ChainShape)this.shape).createLoop(this.vertices);
    }

    @Override
    public void drawTransparent(GameCanvas canvas) {
        canvas.drawTransparent(this.lights, this.getX() * gameScale, this.getY() * gameScale, this.origin.x, this.origin.y, (float)this.lights.getRegionWidth(), (float)this.lights.getRegionHeight(), 0.4f);
    }

    @Override
    public void drawTransparent(GameCanvas canvas, float alpha) {
        canvas.drawTransparent(this.lights, this.getX() * gameScale, this.getY() * gameScale, this.origin.x, this.origin.y, (float)this.lights.getRegionWidth(), (float)this.lights.getRegionHeight(), alpha);
    }

    @Override
    public GameObject.ObjectType getType() {
        return GameObject.ObjectType.DOOR;
    }

    @Override
    public boolean isActive(GameObject.ColorMode worldColorMode) {
        return !this.opened;
    }
}

