/*
 * Decompiled with CFR 0.152.
 */
package com.chrominance.game.Model;

import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.CircleShape;
import com.badlogic.gdx.physics.box2d.Fixture;
import com.badlogic.gdx.physics.box2d.PolygonShape;
import com.badlogic.gdx.physics.box2d.Shape;
import com.chrominance.game.Model.GameObject;
import com.chrominance.game.util.FilmStrip;

public abstract class EntityObject
extends GameObject {
    protected Shape shape;
    private Vector2 dimension;
    private Vector2 hbOrigin;
    private Vector2 sizeCache;
    private Fixture geometry;
    private float[] vertices;
    protected FilmStrip animator;

    public EntityObject(float x, float y) {
        super(x, y);
    }

    public EntityObject(float x, float y, float radius) {
        super(x, y);
        this.dimension = new Vector2(radius * 2.0f / gameScale, radius * 2.0f / gameScale);
        this.sizeCache = new Vector2();
        this.shape = new CircleShape();
        this.vertices = new float[8];
        this.geometry = null;
        this.resize(radius);
    }

    public EntityObject(float x, float y, int hbx, int hby, int hbwidth, int hbheight) {
        super(x, y);
        this.dimension = new Vector2(hbwidth, hbheight);
        this.hbOrigin = new Vector2(hbx, hby);
        this.shape = new PolygonShape();
        this.sizeCache = new Vector2();
        this.vertices = new float[8];
        float halfwidth = hbwidth / 2;
        float halfheight = hbheight / 2;
        this.sizeCache.set(((float)hbx - halfwidth) / gameScale, ((float)hby - halfheight) / gameScale);
        ((PolygonShape)this.shape).setAsBox((float)hbwidth / (2.0f * gameScale), (float)hbheight / (2.0f * gameScale), this.sizeCache, 0.0f);
        this.geometry = null;
    }

    private void resize(float radius) {
        this.shape.setRadius(radius);
    }

    public Vector2 getDimension() {
        return this.sizeCache.set(this.dimension);
    }

    public void setDimension(Vector2 value) {
        this.setDimension(value.x, value.y);
    }

    public Vector2 getHbOrigin() {
        return this.sizeCache.set(this.hbOrigin);
    }

    public void setDimension(float width, float height) {
        this.dimension.set(width, height);
        this.markDirty(true);
        this.resize(width);
    }

    public float getWidth() {
        return this.dimension.x;
    }

    public void setWidth(float value) {
        this.sizeCache.set(value, this.dimension.y);
        this.setDimension(this.sizeCache);
    }

    public float getHeight() {
        return this.dimension.y;
    }

    public void setHeight(float value) {
        this.sizeCache.set(this.dimension.x, value);
        this.setDimension(this.sizeCache);
    }

    public void setTexture(TextureRegion region) {
        this.animator = (FilmStrip)region;
        this.origin = new Vector2((float)this.animator.getRegionWidth() / 2.0f, (float)this.animator.getRegionHeight() / 2.0f);
    }

    public void setTexture(TextureRegion region, Vector2 origin) {
        this.animator = (FilmStrip)region;
        this.origin = origin;
    }

    @Override
    protected void createFixtures() {
        if (this.body == null) {
            return;
        }
        this.releaseFixtures();
        this.fixture.shape = this.shape;
        this.geometry = this.body.createFixture(this.fixture);
        this.shape.dispose();
        this.shape = null;
        this.markDirty(false);
    }

    @Override
    protected void releaseFixtures() {
        if (this.geometry != null) {
            this.body.destroyFixture(this.geometry);
            this.geometry = null;
        }
    }

    @Override
    public float getLinearDamping() {
        return this.bodyinfo.linearDamping;
    }

    @Override
    public void setLinearDamping(float value) {
        this.bodyinfo.linearDamping = value;
    }
}

