/*
 * Decompiled with CFR 0.152.
 */
package com.chrominance.game.Model;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.BodyDef;
import com.badlogic.gdx.physics.box2d.Filter;
import com.badlogic.gdx.physics.box2d.Fixture;
import com.badlogic.gdx.physics.box2d.World;
import com.chrominance.game.GameCanvas;
import com.chrominance.game.Model.Obstacle;

public abstract class GameObject
extends Obstacle {
    protected static final float WALL_DENSITY = 0.0f;
    protected Vector2 textureOrigin;
    protected ColorMode colorMode;
    protected Texture texture;
    protected Texture inactiveTexture;
    protected String textureKey;
    public static float gameScale = 32.0f;
    protected Body body = null;
    protected Vector2 origin;
    protected Color[] colors = new Color[]{new Color(0.6f, 1.0f, 1.0f, 1.0f), new Color(1.0f, 1.0f, 0.6f, 1.0f), new Color(1.0f, 0.6f, 1.0f, 1.0f), Color.GRAY};
    protected boolean isDirty;
    private Vector2 positionCache;

    public GameObject(float x, float y) {
        super(x, y);
        this.origin = new Vector2();
        this.positionCache = new Vector2();
    }

    @Override
    public float getX() {
        return this.body != null ? this.body.getPosition().x : super.getX();
    }

    @Override
    public void setX(float x) {
        if (this.body != null) {
            this.positionCache.set(x, this.getY());
            this.body.setTransform(this.positionCache, this.body.getAngle());
        } else {
            this.positionCache.set(x, this.getY());
            super.setPosition(this.positionCache);
        }
    }

    @Override
    public float getY() {
        return this.body != null ? this.body.getPosition().y : super.getY();
    }

    @Override
    public void setY(float y) {
        if (this.body != null) {
            this.positionCache.set(this.getX(), y);
            this.body.setTransform(this.positionCache, this.body.getAngle());
        } else {
            this.positionCache.set(this.getX(), y);
            super.setPosition(this.positionCache);
        }
    }

    public abstract ObjectType getType();

    public abstract void switchColorMode(ColorMode var1, boolean var2);

    public ColorMode getColorMode() {
        return this.colorMode;
    }

    public void setColorMode(ColorMode cmode) {
        this.colorMode = cmode;
    }

    public String getStringFromColorMode(ColorMode cmode) {
        switch (cmode) {
            case NONE: {
                return "full";
            }
            case CYAN: {
                return "cyan";
            }
            case MAGENTA: {
                return "magenta";
            }
            case YELLOW: {
                return "yellow";
            }
        }
        throw new IllegalArgumentException();
    }

    public abstract boolean isActive(ColorMode var1);

    public Texture getTexture() {
        return this.texture;
    }

    public void setTexture(Texture t) {
        this.texture = t;
        if (this.origin == null) {
            this.origin = new Vector2();
        }
        this.origin.set((float)t.getWidth() / 2.0f, (float)t.getHeight() / 2.0f);
    }

    public void setInactiveTexture(Texture t) {
        this.inactiveTexture = t;
        if (this.origin == null) {
            this.origin = new Vector2();
        }
        this.origin.set((float)t.getWidth() / 2.0f, (float)t.getHeight() / 2.0f);
    }

    public String getTextureKey() {
        return this.textureKey;
    }

    public void setTextureKey(String key) {
        this.textureKey = key;
    }

    @Override
    public BodyDef.BodyType getBodyType() {
        return this.body != null ? this.body.getType() : super.getBodyType();
    }

    @Override
    public void setBodyType(BodyDef.BodyType value) {
        if (this.body != null) {
            this.body.setType(value);
        } else {
            super.setBodyType(value);
        }
    }

    @Override
    public Vector2 getPosition() {
        return this.body != null ? this.body.getPosition() : super.getPosition();
    }

    @Override
    public void setPosition(Vector2 value) {
        if (this.body != null) {
            this.body.setTransform(value, this.body.getAngle());
        } else {
            super.setPosition(value);
        }
    }

    @Override
    public void setPosition(float x, float y) {
        if (this.body != null) {
            this.positionCache.set(x, y);
            this.body.setTransform(this.positionCache, this.body.getAngle());
        } else {
            super.setPosition(x, y);
        }
    }

    @Override
    public float getAngle() {
        return this.body != null ? this.body.getAngle() : super.getAngle();
    }

    @Override
    public void setAngle(float value) {
        if (this.body != null) {
            this.body.setTransform(this.body.getPosition(), value);
        } else {
            super.setAngle(value);
        }
    }

    @Override
    public Vector2 getLinearVelocity() {
        return this.body != null ? this.body.getLinearVelocity() : super.getLinearVelocity();
    }

    @Override
    public void setLinearVelocity(Vector2 value) {
        if (this.body != null) {
            this.body.setLinearVelocity(value);
        } else {
            super.setLinearVelocity(value);
        }
    }

    @Override
    public float getVX() {
        return this.body != null ? this.body.getLinearVelocity().x : super.getVX();
    }

    @Override
    public void setVX(float value) {
        if (this.body != null) {
            this.velocityCache.set(value, this.body.getLinearVelocity().y);
            this.body.setLinearVelocity(this.velocityCache);
        } else {
            super.setVX(value);
        }
    }

    @Override
    public float getVY() {
        return this.body != null ? this.body.getLinearVelocity().y : super.getVY();
    }

    @Override
    public void setVY(float value) {
        if (this.body != null) {
            this.velocityCache.set(this.body.getLinearVelocity().x, value);
            this.body.setLinearVelocity(this.velocityCache);
        } else {
            super.setVY(value);
        }
    }

    @Override
    public float getAngularVelocity() {
        return this.body != null ? this.body.getAngularVelocity() : super.getAngularVelocity();
    }

    @Override
    public void setAngularVelocity(float value) {
        if (this.body != null) {
            this.body.setAngularVelocity(value);
        } else {
            super.setAngularVelocity(value);
        }
    }

    @Override
    public boolean isActive() {
        return this.body != null ? this.body.isActive() : super.isActive();
    }

    @Override
    public void setActive(boolean value) {
        if (this.body != null) {
            this.body.setActive(value);
        } else {
            super.setActive(value);
        }
    }

    @Override
    public boolean isAwake() {
        return this.body != null ? this.body.isAwake() : super.isAwake();
    }

    @Override
    public void setAwake(boolean value) {
        if (this.body != null) {
            this.body.setAwake(value);
        } else {
            super.setAwake(value);
        }
    }

    @Override
    public void setDensity(float value) {
        super.setDensity(value);
        if (this.body != null) {
            for (Fixture f : this.body.getFixtureList()) {
                f.setDensity(value);
            }
        }
    }

    @Override
    public void setFriction(float value) {
        super.setFriction(value);
        if (this.body != null) {
            for (Fixture f : this.body.getFixtureList()) {
                f.setFriction(value);
            }
        }
    }

    @Override
    public void setRestitution(float value) {
        super.setRestitution(value);
        if (this.body != null) {
            for (Fixture f : this.body.getFixtureList()) {
                f.setRestitution(value);
            }
        }
    }

    @Override
    public void setSensor(boolean value) {
        super.setSensor(value);
        if (this.body != null) {
            for (Fixture f : this.body.getFixtureList()) {
                f.setSensor(value);
            }
        }
    }

    @Override
    public void setFilterData(Filter value) {
        super.setFilterData(value);
        if (this.body != null) {
            for (Fixture f : this.body.getFixtureList()) {
                f.setFilterData(value);
            }
        }
    }

    @Override
    public Vector2 getCentroid() {
        return this.body != null ? this.body.getLocalCenter() : super.getCentroid();
    }

    @Override
    public void setCentroid(Vector2 value) {
        super.setCentroid(value);
        if (this.body != null) {
            this.body.setMassData(this.massdata);
        }
    }

    @Override
    public float getInertia() {
        return this.body != null ? this.body.getInertia() : super.getInertia();
    }

    @Override
    public void setInertia(float value) {
        super.setInertia(value);
        if (this.body != null) {
            this.body.setMassData(this.massdata);
        }
    }

    @Override
    public float getMass() {
        return this.body != null ? this.body.getMass() : super.getMass();
    }

    @Override
    public void setMass(float value) {
        super.setMass(value);
        if (this.body != null) {
            this.body.setMassData(this.massdata);
        }
    }

    @Override
    public void resetMass() {
        super.resetMass();
        if (this.body != null) {
            this.body.resetMassData();
        }
    }

    @Override
    public void draw(GameCanvas canvas) {
        canvas.draw(this.texture, this.getX() * gameScale, this.getY() * gameScale, this.origin.x, this.origin.y, this.texture.getWidth(), this.texture.getHeight());
    }

    public void draw(GameCanvas canvas, float f, float x, float y) {
        canvas.draw(this.texture, Color.WHITE, x, y, (float)this.texture.getWidth(), (float)this.texture.getHeight(), 0.0f, f, f);
    }

    public void inActiveDraw(GameCanvas canvas) {
        canvas.draw(this.inactiveTexture, this.getX() * gameScale, this.getY() * gameScale, this.origin.x, this.origin.y, this.texture.getWidth(), this.texture.getHeight());
    }

    public void drawTransparent(GameCanvas canvas) {
        canvas.drawTransparent(this.texture, this.getX() * gameScale, this.getY() * gameScale, this.origin.x, this.origin.y, (float)this.texture.getWidth(), (float)this.texture.getHeight(), 0.7f);
    }

    public void drawTransparent(GameCanvas canvas, float alpha) {
        canvas.drawTransparent(this.texture, this.getX() * gameScale, this.getY() * gameScale, this.origin.x, this.origin.y, (float)this.texture.getWidth(), (float)this.texture.getHeight(), alpha);
    }

    @Override
    public Body getBody() {
        return this.body;
    }

    @Override
    public boolean activatePhysics(World world) {
        this.bodyinfo.active = true;
        this.body = world.createBody(this.bodyinfo);
        this.body.setUserData(this);
        if (this.body != null) {
            this.createFixtures();
            return true;
        }
        this.bodyinfo.active = false;
        return false;
    }

    @Override
    public void deactivatePhysics(World world) {
        if (this.body != null) {
            this.setBodyState(this.body);
            world.destroyBody(this.body);
            this.body = null;
            this.bodyinfo.active = false;
        }
    }

    protected abstract void createFixtures();

    protected abstract void releaseFixtures();

    @Override
    public void update(float delta) {
        if (this.isDirty()) {
            this.createFixtures();
        }
    }

    @Override
    public boolean isDirty() {
        return this.isDirty;
    }

    @Override
    public void markDirty(boolean value) {
        this.isDirty = value;
    }

    public void createHole(int w, int h, Color color) {
        Pixmap pixmap = new Pixmap(w, h, Pixmap.Format.RGBA8888);
        pixmap.setColor(Color.WHITE);
        pixmap.fillRectangle(0, 0, w, h);
        pixmap.setColor(color);
        pixmap.fillCircle(w / 2, h / 2, w / 3);
        this.setTexture(new Texture(pixmap));
        pixmap.dispose();
        pixmap = null;
    }

    public void createTrap(int w, int h, Color color) {
        Pixmap pixmap = new Pixmap(w, h, Pixmap.Format.RGBA8888);
        pixmap.setColor(Color.WHITE);
        pixmap.fillRectangle(0, 0, w, h);
        pixmap.setColor(color);
        pixmap.fillRectangle(2 * w / 10, 2 * h / 10, 6 * w / 10, 6 * h / 10);
        this.setTexture(new Texture(pixmap));
        pixmap.dispose();
        pixmap = null;
    }

    public void createExit(int w, int h) {
        Pixmap pixmap = new Pixmap(w, h, Pixmap.Format.RGBA8888);
        pixmap.setColor(Color.RED);
        pixmap.fillRectangle(0, 0, w, h);
        pixmap.setColor(Color.ORANGE);
        pixmap.fillRectangle(0, h / 6, w, h);
        pixmap.setColor(Color.YELLOW);
        pixmap.fillRectangle(0, 2 * h / 6, w, h);
        pixmap.setColor(Color.GREEN);
        pixmap.fillRectangle(0, 3 * h / 6, w, h);
        pixmap.setColor(Color.BLUE);
        pixmap.fillRectangle(0, 4 * h / 6, w, h);
        pixmap.setColor(Color.PURPLE);
        pixmap.fillRectangle(0, 5 * h / 6, w, h);
        this.setTexture(new Texture(pixmap));
        this.texture.setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
        pixmap.dispose();
        pixmap = null;
    }

    public static enum ColorMode {
        CYAN,
        YELLOW,
        MAGENTA,
        NONE;

    }

    public static enum ObjectType {
        COLORWALL,
        DEFAULTWALL,
        DEFAULTFLOOR,
        PLAYER,
        GARBAGECOLLECTOR,
        EXIT,
        HOLE,
        TRAP,
        WORLD,
        PRESSUREPLATE,
        DOOR;

    }
}

