/*
 * Decompiled with CFR 0.152.
 */
package com.chrominance.game.Model;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Filter;
import com.badlogic.gdx.physics.box2d.Fixture;
import com.badlogic.gdx.physics.box2d.PolygonShape;
import com.chrominance.game.GameCanvas;
import com.chrominance.game.Model.EntityObject;
import com.chrominance.game.Model.GameObject;
import com.chrominance.game.util.FilmStrip;
import com.chrominance.game.util.JsonAssetManager;

public class GarbageCollector
extends EntityObject {
    private float radius;
    private Fixture sensor;
    public static float DEFAULT_VELOCITY = 45.0f;
    private boolean chased;
    public boolean loop = false;
    public float t = 0.0f;
    public int vertexIndex = 0;
    public Vector2[] roamPathParsed = new Vector2[0];
    public Vector2[] positions;
    BitmapFont font = new BitmapFont();
    private int health;
    private static final float ANIMATION_SPEED = 0.05f;
    private static final int NUM_ANIM_FRAMES = 4;
    private static final int NUM_DEATH_FRAMES = 9;
    private static final int NUM_SPAWN_FRAMES = 7;
    private float animFrame;
    private AnimationState animState;
    public int dir = 1;
    private Vector2 originOffset;
    private FilmStrip idle;
    private FilmStrip walking;
    private FilmStrip death;
    private FilmStrip respawn;
    private Vector2 spawnPos;
    private Vector2 updateCache;
    private static final Vector2 zeroVector = new Vector2(0.0f, 0.0f);

    public GarbageCollector(Vector2 screenPos, float radius, GameObject.ColorMode colorMode, String roamPath) {
        super(screenPos.x, screenPos.y, radius);
        this.spawnPos = screenPos.cpy();
        this.health = 100;
        this.colorMode = colorMode;
        this.font.getData().setScale(2.0f);
        this.radius = radius;
        this.originOffset = new Vector2();
        this.updateCache = new Vector2();
        if (roamPath.length() > 3) {
            this.roamPathParsed = this.parsePath(roamPath);
            if (this.roamPathParsed.length > 0) {
                this.vertexIndex = 1;
            }
        }
        String cString = this.getStringFromColorMode(colorMode);
        this.idle = (FilmStrip)JsonAssetManager.getInstance().getEntry("gc_" + cString, TextureRegion.class);
        this.walking = (FilmStrip)JsonAssetManager.getInstance().getEntry("gc_" + cString + "_walking_south", TextureRegion.class);
        this.death = (FilmStrip)JsonAssetManager.getInstance().getEntry("gc_" + cString + "_death", TextureRegion.class);
        this.respawn = (FilmStrip)JsonAssetManager.getInstance().getEntry("gc_" + cString + "_respawn", TextureRegion.class);
        this.originOffset.set(32.0f, 32.0f);
        this.setTexture(this.idle, this.originOffset);
    }

    public float getRadius() {
        return this.radius;
    }

    private Vector2[] parsePath(String roamPath) {
        int i;
        String[] ps = roamPath.split(";");
        Vector2[] directions = new Vector2[ps.length];
        this.positions = new Vector2[ps.length];
        directions[0] = zeroVector;
        for (i = 0; i < ps.length; ++i) {
            String s = ps[i].substring(1, ps[i].length() - 1);
            String[] c = s.split(",");
            this.positions[i] = new Vector2((Float.parseFloat(c[0]) + 0.5f) * 64.0f, (Float.parseFloat(c[1]) + 0.5f) * 64.0f);
        }
        if (this.positions[0].epsilonEquals(this.positions[this.positions.length - 1])) {
            this.loop = true;
        }
        for (i = 1; i < ps.length; ++i) {
            directions[i] = new Vector2(this.positions[i]).sub(this.positions[i - 1]);
            directions[i].y = -1.0f * directions[i].y;
        }
        return directions;
    }

    @Override
    public boolean isActive(GameObject.ColorMode c) {
        return c != this.colorMode;
    }

    @Override
    public GameObject.ObjectType getType() {
        return GameObject.ObjectType.GARBAGECOLLECTOR;
    }

    @Override
    public void draw(GameCanvas canvas) {
        this.animator.setFrame((int)this.animFrame);
        if (this.animState == AnimationState.DEATH) {
            canvas.drawTransparent(this.animator, this.getX() * gameScale, this.getY() * gameScale, (float)(this.death.getRegionWidth() / 2), (float)(this.death.getRegionHeight() / 2), this.getWidth(), this.getHeight(), 1.0f);
        } else {
            canvas.draw(this.animator, Color.WHITE, this.origin.x, this.origin.y, this.getX() * gameScale, this.getY() * gameScale, 0.0f, 1.0f, 1.0f);
        }
    }

    @Override
    public void drawTransparent(GameCanvas canvas, float alpha) {
        if (this.animState == AnimationState.IDLE) {
            this.animFrame = 0.0f;
        }
        this.animator.setFrame((int)this.animFrame);
        if (this.animState == AnimationState.DEATH) {
            canvas.drawTransparent(this.animator, this.getX() * gameScale, this.getY() * gameScale, (float)(this.death.getRegionWidth() / 2), (float)(this.death.getRegionHeight() / 2), this.getWidth(), this.getHeight(), alpha);
        } else {
            canvas.drawTransparent(this.animator, this.getX() * gameScale, this.getY() * gameScale, this.origin.x, this.origin.y, this.getWidth(), this.getHeight(), alpha);
        }
    }

    @Override
    public void drawTransparent(GameCanvas canvas) {
        this.drawTransparent(canvas, 0.4f);
    }

    @Override
    public void switchColorMode(GameObject.ColorMode c, boolean isPainting) {
        if (isPainting) {
            if (c == GameObject.ColorMode.NONE) {
                throw new IllegalArgumentException();
            }
            this.updateTextures(c);
            this.colorMode = c;
        }
    }

    public void setWalkDirection(float dx, float dy) {
        String cString = this.getStringFromColorMode(this.colorMode);
        float eps = 1.0E-6f;
        float angle = MathUtils.atan2(dy, dx);
        String dir = Math.abs(dx) > Math.abs(dy) ? (dx > 0.0f ? "east" : "west") : (dy > 0.0f ? "north" : "south");
        String key = "gc_" + cString + "_walking_" + dir;
        this.walking = (FilmStrip)JsonAssetManager.getInstance().getEntry(key, TextureRegion.class);
    }

    public void switchAnimator() {
        switch (this.animState) {
            case IDLE: {
                this.animator = this.idle;
                break;
            }
            case WALKING: {
                this.animator = this.walking;
                break;
            }
            case TELEPORTING: {
                this.animator = this.respawn;
                break;
            }
            case RESPAWNING: {
                this.animator = this.respawn;
                break;
            }
            case DEATH: {
                this.animator = this.death;
                break;
            }
        }
    }

    public void setAnimState(AnimationState state) {
        this.animState = state;
        if (this.animState == AnimationState.RESPAWNING) {
            this.animFrame = 0.0f;
            this.animator = this.respawn;
        } else if (this.animState == AnimationState.TELEPORTING) {
            this.animFrame = 6.0f;
            this.animator = this.respawn;
        } else if (this.animState == AnimationState.DEATH) {
            this.animFrame = 0.0f;
            this.animator = this.death;
        }
    }

    public void setRespawnFilter() {
        Filter f = new Filter();
        f.maskBits = 0;
        this.setFilterData(f);
        f = null;
    }

    public void setCollisionFilter() {
        Filter f = new Filter();
        f.maskBits = (short)-1;
        this.setFilterData(f);
        f = null;
    }

    public void setSensor() {
        PolygonShape shape = new PolygonShape();
        shape.setAsBox((float)this.animator.getRwidth() / (2.0f * gameScale), (float)(2 * this.animator.getRheight()) / (2.0f * gameScale));
        this.sensor = this.body.createFixture(shape, 0.0f);
        this.sensor.setSensor(true);
        shape.dispose();
        shape = null;
    }

    public void removeSensor() {
        this.body.destroyFixture(this.sensor);
    }

    public AnimationState getAnimState() {
        return this.animState;
    }

    public void finishAnimation() {
        if (this.animState == AnimationState.RESPAWNING) {
            this.animFrame = (float)((double)this.animFrame + 0.12500000186264515);
            if (this.animFrame >= 7.0f) {
                this.animFrame = 0.0f;
                this.animState = AnimationState.IDLE;
                this.animator = this.idle;
                this.setCollisionFilter();
            }
        } else if (this.animState == AnimationState.TELEPORTING) {
            this.animFrame = (float)((double)this.animFrame - 0.12500000186264515);
            if (this.animFrame < 0.0f) {
                this.animFrame = 0.0f;
                this.animState = AnimationState.RESPAWNING;
                this.animator = this.respawn;
                this.body.setTransform(this.spawnPos, 0.0f);
            }
        } else if (this.animState == AnimationState.DEATH) {
            this.animFrame += 0.45000002f;
            if (this.animFrame >= 9.0f) {
                this.animFrame = 0.0f;
                this.markDirty(true);
            }
        }
    }

    public void update(float delta, Vector2 v) {
        if (this.animState == AnimationState.RESPAWNING) {
            this.animFrame = (float)((double)this.animFrame + 0.12500000186264515);
            if (this.animFrame >= 7.0f) {
                this.animFrame = 0.0f;
                this.animState = AnimationState.IDLE;
                this.animator = this.idle;
                this.setCollisionFilter();
            }
        } else if (this.animState == AnimationState.TELEPORTING) {
            this.animFrame = (float)((double)this.animFrame - 0.12500000186264515);
            if (this.animFrame < 0.0f) {
                this.animFrame = 0.0f;
                this.animState = AnimationState.RESPAWNING;
                this.animator = this.respawn;
                this.body.setTransform(this.spawnPos, 0.0f);
            }
        } else if (this.animState == AnimationState.DEATH) {
            this.animFrame += 0.45000002f;
            if (this.animFrame >= 9.0f) {
                this.animFrame = 0.0f;
                this.markDirty(true);
            }
        } else {
            this.animFrame += 0.05f;
            if (this.animFrame >= 4.0f) {
                this.animFrame -= 4.0f;
            }
            if (v.len() > 0.0f) {
                this.t = 0.0f;
                this.body.applyForce(v.nor().scl(DEFAULT_VELOCITY), zeroVector, true);
                this.chased = true;
                this.setWalkDirection(v.x, v.y);
                this.animState = AnimationState.WALKING;
                this.animator = this.walking;
            } else if (this.roamPathParsed.length > 0) {
                if (this.chased) {
                    this.t = 0.0f;
                    this.vertexIndex = 1;
                }
                this.t += Gdx.graphics.getDeltaTime();
                this.updateCache.set(this.getX() * gameScale, this.getY() * gameScale);
                if (this.t > 1.0f && this.updateCache.epsilonEquals(this.positions[this.vertexIndex], 10.0f)) {
                    this.t = Gdx.graphics.getDeltaTime();
                    this.vertexIndex += this.dir;
                    if (this.vertexIndex == this.roamPathParsed.length && this.loop || this.vertexIndex == -1) {
                        this.vertexIndex = 1;
                        this.dir = 1;
                    } else if (this.vertexIndex == this.roamPathParsed.length) {
                        this.dir = -1;
                        this.vertexIndex = this.roamPathParsed.length - 1;
                        this.vertexIndex += this.dir;
                    }
                }
                this.updateCache.set(this.roamPathParsed[this.vertexIndex]);
                this.body.applyForce(this.updateCache.nor().scl(DEFAULT_VELOCITY), zeroVector, true);
                this.chased = false;
                this.setWalkDirection(v.x, v.y);
                this.animState = AnimationState.WALKING;
                this.animator = this.walking;
            } else {
                this.animState = AnimationState.IDLE;
                this.animator = this.idle;
                this.body.setLinearVelocity(0.0f, 0.0f);
            }
        }
    }

    public void updateTextures(GameObject.ColorMode c) {
        String oldColor = this.getStringFromColorMode(this.colorMode);
        String newColor = this.getStringFromColorMode(c);
        this.idle = (FilmStrip)JsonAssetManager.getInstance().getEntry(this.idle.getName().replace(oldColor, newColor), TextureRegion.class);
        this.walking = (FilmStrip)JsonAssetManager.getInstance().getEntry(this.walking.getName().replace(oldColor, newColor), TextureRegion.class);
        this.switchAnimator();
    }

    public static enum AnimationState {
        IDLE,
        WALKING,
        DEATH,
        TELEPORTING,
        RESPAWNING;

    }
}

