/*
 * Decompiled with CFR 0.152.
 */
package com.chrominance.game.Model;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.BodyDef;
import com.badlogic.gdx.physics.box2d.ChainShape;
import com.chrominance.game.Model.GameObject;
import com.chrominance.game.Model.TileObject;
import com.chrominance.game.util.JsonAssetManager;

public class Hole
extends TileObject {
    public Hole(Vector2 screenPos, Vector2 hBox, int size, GameObject.ColorMode objColor, String key) {
        super(screenPos.x, screenPos.y);
        this.dimension = new Vector2(hBox.x, hBox.y);
        this.sizeCache = new Vector2();
        this.shape = new ChainShape();
        this.vertices = new float[8];
        this.geometry = null;
        this.resize(hBox.x, hBox.y);
        this.colorMode = objColor;
        this.createHole(size, size, this.colors[this.colorMode.ordinal()]);
        this.setBodyType(BodyDef.BodyType.StaticBody);
        this.fixture.isSensor = true;
        this.setTextureKey(key);
        this.setTexture(JsonAssetManager.getInstance().getEntry(key, Texture.class));
    }

    @Override
    public GameObject.ObjectType getType() {
        return GameObject.ObjectType.HOLE;
    }

    @Override
    public boolean isActive(GameObject.ColorMode worldColorMode) {
        if (this.getColorMode() == GameObject.ColorMode.NONE) {
            return true;
        }
        return worldColorMode != this.getColorMode();
    }

    @Override
    public void switchColorMode(GameObject.ColorMode c, boolean isPainting) {
        if (isPainting) {
            String cString = this.getStringFromColorMode(this.colorMode);
            this.colorMode = c;
            switch (c) {
                case NONE: {
                    break;
                }
                case CYAN: {
                    this.setTexture(JsonAssetManager.getInstance().getEntry(this.getTextureKey().replace(cString, "cyan"), Texture.class));
                    break;
                }
                case MAGENTA: {
                    this.setTexture(JsonAssetManager.getInstance().getEntry(this.getTextureKey().replace(cString, "magenta"), Texture.class));
                    break;
                }
                case YELLOW: {
                    this.setTexture(JsonAssetManager.getInstance().getEntry(this.getTextureKey().replace(cString, "yellow"), Texture.class));
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
    }

    private void resize(float width, float height) {
        this.vertices[0] = -width / 4.0f;
        this.vertices[1] = -height / 4.0f;
        this.vertices[2] = -width / 4.0f;
        this.vertices[3] = height / 4.0f;
        this.vertices[4] = width / 4.0f;
        this.vertices[5] = height / 4.0f;
        this.vertices[6] = width / 4.0f;
        this.vertices[7] = -height / 4.0f;
        ((ChainShape)this.shape).createLoop(this.vertices);
    }
}

