/*
 * Decompiled with CFR 0.152.
 */
package com.chrominance.game.Model;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.chrominance.game.GameCanvas;
import com.chrominance.game.InputController;
import com.chrominance.game.Model.EntityObject;
import com.chrominance.game.Model.GameObject;
import com.chrominance.game.util.FilmStrip;
import com.chrominance.game.util.JsonAssetManager;

public class Player
extends EntityObject {
    public static float DEFAULT_VELOCITY = 70.0f;
    private int health = 100;
    private int paint;
    private final Vector2 zeroVector = new Vector2(0.0f, 0.0f);
    private Vector2 forceCache;
    private static final float ANIMATION_SPEED = 0.05f;
    private static final int NUM_ANIM_FRAMES_WALKING = 4;
    private static final int NUM_ANIM_FRAMES_DYING = 9;
    private float animFrame = 0.0f;
    private AnimationState animState;
    private boolean finishedDying;
    private FilmStrip idle;
    private FilmStrip walking;
    private FilmStrip dying;

    public Player(Vector2 screenPos, float radius) {
        super(screenPos.x, screenPos.y, radius);
        this.colorMode = GameObject.ColorMode.NONE;
        this.finishedDying = false;
        this.forceCache = new Vector2();
        this.paint = 0;
        this.idle = new FilmStrip(JsonAssetManager.getInstance().getEntry("player", Texture.class), 1, 1, 1);
        this.walking = (FilmStrip)JsonAssetManager.getInstance().getEntry("player_walking_south", TextureRegion.class);
        this.dying = (FilmStrip)JsonAssetManager.getInstance().getEntry("player_dying", TextureRegion.class);
        Vector2 originOffset = new Vector2();
        originOffset.set(32.0f, 22.0f);
        this.setTexture(this.idle, originOffset);
    }

    public Player(Vector2 screenPos, int hbx, int hby, int hbwidth, int hbheight) {
        super(screenPos.x, screenPos.y, hbx, hby, hbwidth, hbheight);
        this.colorMode = GameObject.ColorMode.NONE;
        this.finishedDying = false;
        this.forceCache = new Vector2();
        this.paint = 0;
        this.idle = new FilmStrip(JsonAssetManager.getInstance().getEntry("player", Texture.class), 1, 1, 1);
        this.walking = (FilmStrip)JsonAssetManager.getInstance().getEntry("player_walking_south", TextureRegion.class);
        this.dying = (FilmStrip)JsonAssetManager.getInstance().getEntry("player_dying", TextureRegion.class);
        Vector2 originOffset = new Vector2();
        originOffset.set(32.0f, 22.0f);
        this.setTexture(this.idle, originOffset);
    }

    @Override
    public void switchColorMode(GameObject.ColorMode cmode, boolean isPainting) {
    }

    @Override
    public void draw(GameCanvas canvas) {
        if (this.animState == AnimationState.IDLE) {
            this.animFrame = 0.0f;
        }
        this.animator.setFrame((int)this.animFrame);
        canvas.draw(this.animator, Color.WHITE, this.origin.x, this.origin.y, this.getX() * gameScale, this.getY() * gameScale, 0.0f, 1.0f, 1.0f);
    }

    @Override
    public boolean isActive(GameObject.ColorMode c) {
        return true;
    }

    @Override
    public GameObject.ObjectType getType() {
        return GameObject.ObjectType.PLAYER;
    }

    @Override
    public void update(float delta) {
        if (this.animState == AnimationState.WALKING) {
            this.animFrame += 0.05f;
            if (this.animFrame >= 4.0f) {
                this.animFrame -= 4.0f;
            }
        }
        if (this.animState == AnimationState.DYING) {
            this.animFrame += 0.1f;
            if (this.animFrame >= 9.0f) {
                this.animFrame = 8.0f;
                this.finishedDying = true;
            }
            return;
        }
        int h = InputController.getHorizontalMovement();
        int v = InputController.getVerticalMovement();
        if (this.health < 1) {
            this.animState = AnimationState.DYING;
            this.animator = this.dying;
            this.body.setActive(false);
            return;
        }
        if (Math.abs(h) <= 0 && Math.abs(v) <= 0) {
            this.animState = AnimationState.IDLE;
            this.animator = this.idle;
            this.body.setLinearVelocity(0.0f, 0.0f);
            return;
        }
        this.animState = AnimationState.WALKING;
        this.animator = this.walking;
        this.setWalkDirection(h, v);
        this.forceCache.set(h, v);
        this.forceCache.nor();
        this.body.applyForce(this.forceCache.scl(DEFAULT_VELOCITY), this.zeroVector, true);
    }

    public void setWalkDirection(float dx, float dy) {
        String dir;
        float eps = 1.0E-6f;
        float angle = MathUtils.atan2(dy, dx);
        if (Math.abs(angle) < eps) {
            dir = "east";
        } else if (Math.abs((double)angle - Math.PI) < (double)eps) {
            dir = "west";
        } else {
            dir = angle > eps ? "north" : "south";
            if ((double)Math.abs(angle) < 1.5707963267948966 && Math.abs((double)Math.abs(angle) - 1.5707963267948966) > (double)eps) {
                dir = dir + "east";
            } else if ((double)Math.abs(angle) > 1.5707963267948966 && Math.abs((double)Math.abs(angle) - 1.5707963267948966) > (double)eps) {
                dir = dir + "west";
            }
        }
        this.walking = (FilmStrip)JsonAssetManager.getInstance().getEntry("player_walking_" + dir, TextureRegion.class);
    }

    public void updateHealth(int x) {
        if (this.animState != AnimationState.DYING) {
            this.health += x;
        }
    }

    public int getHealth() {
        return this.health;
    }

    public int getPaint() {
        return this.paint;
    }

    public void setPaint(int p) {
        this.paint = p;
        if (this.paint <= 0) {
            InputController.setPlayerHasPaint(false);
        } else {
            InputController.setPlayerHasPaint(true);
        }
    }

    public boolean finishedDying() {
        return this.finishedDying;
    }

    private static enum AnimationState {
        IDLE,
        WALKING,
        DYING;

    }
}

