/*
 * Decompiled with CFR 0.152.
 */
package com.chrominance.game.Model;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.BodyDef;
import com.badlogic.gdx.physics.box2d.PolygonShape;
import com.chrominance.game.Model.GameObject;
import com.chrominance.game.Model.TileObject;
import com.chrominance.game.util.JsonAssetManager;

public class PressurePlate
extends TileObject {
    private int setid = 0;
    private boolean steppedOn = false;
    private static float PLATE_DIM = 0.875f;

    public PressurePlate(float x, float y) {
        super(x, y);
    }

    public PressurePlate(Vector2 screenPos, Vector2 hBox, int size, GameObject.ColorMode objColor, String key, int setId) {
        super(screenPos.x, screenPos.y);
        this.setid = setId;
        this.dimension = new Vector2(hBox.x, hBox.y);
        this.sizeCache = new Vector2();
        this.shape = new PolygonShape();
        this.vertices = new float[8];
        this.geometry = null;
        this.resize(hBox.x, hBox.y);
        this.switchColorMode(objColor, true);
        this.textureKey = key;
        this.setBodyType(BodyDef.BodyType.StaticBody);
        this.fixture.isSensor = true;
    }

    public void setSteppedOn(boolean val) {
        this.steppedOn = val;
        if (val) {
            this.setTexture(JsonAssetManager.getInstance().getEntry(this.textureKey + "_stepped", Texture.class));
        } else {
            this.setTexture(JsonAssetManager.getInstance().getEntry(this.textureKey, Texture.class));
        }
    }

    public boolean getSteppedOn() {
        return this.steppedOn;
    }

    public int getSetid() {
        return this.setid;
    }

    private void resize(float width, float height) {
        this.vertices[0] = PLATE_DIM * -width / 2.0f;
        this.vertices[1] = PLATE_DIM * -height / 2.0f;
        this.vertices[2] = PLATE_DIM * -width / 2.0f;
        this.vertices[3] = PLATE_DIM * height / 2.0f;
        this.vertices[4] = PLATE_DIM * width / 2.0f;
        this.vertices[5] = PLATE_DIM * height / 2.0f;
        this.vertices[6] = PLATE_DIM * width / 2.0f;
        this.vertices[7] = PLATE_DIM * -height / 2.0f;
        ((PolygonShape)this.shape).setAsBox(PLATE_DIM * width / 2.0f, PLATE_DIM * height / 2.0f);
    }

    @Override
    public void switchColorMode(GameObject.ColorMode c, boolean isPainting) {
        if (isPainting) {
            this.colorMode = c;
        }
        switch (c) {
            case NONE: {
                if (!isPainting) break;
                this.setTexture(JsonAssetManager.getInstance().getEntry("full_plate", Texture.class));
                break;
            }
            case CYAN: {
                if (!isPainting) break;
                this.setTexture(JsonAssetManager.getInstance().getEntry("cyan_plate", Texture.class));
                break;
            }
            case MAGENTA: {
                if (!isPainting) break;
                this.setTexture(JsonAssetManager.getInstance().getEntry("magenta_plate", Texture.class));
                break;
            }
            case YELLOW: {
                if (!isPainting) break;
                this.setTexture(JsonAssetManager.getInstance().getEntry("yellow_plate", Texture.class));
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public GameObject.ObjectType getType() {
        return GameObject.ObjectType.PRESSUREPLATE;
    }

    @Override
    public boolean isActive(GameObject.ColorMode worldColorMode) {
        if (this.getColorMode() == GameObject.ColorMode.NONE) {
            return true;
        }
        return worldColorMode != this.getColorMode();
    }
}

