/*
 * Decompiled with CFR 0.152.
 */
package com.chrominance.game.Model;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.ChainShape;
import com.badlogic.gdx.physics.box2d.Fixture;
import com.badlogic.gdx.physics.box2d.Shape;
import com.chrominance.game.Model.GameObject;

public abstract class TileObject
extends GameObject {
    protected Shape shape;
    protected Vector2 dimension;
    protected Vector2 sizeCache;
    protected Fixture geometry;
    protected float[] vertices;

    public TileObject(float x, float y) {
        super(x, y);
    }

    public TileObject(float x, float y, float width, float height) {
        super(x, y);
        this.dimension = new Vector2(width, height);
        this.sizeCache = new Vector2();
        this.shape = new ChainShape();
        this.vertices = new float[8];
        this.geometry = null;
        this.resize(width, height);
    }

    public TileObject(float x, float y, float width, float height, float ox, float oy) {
        super(x, y);
        this.dimension = new Vector2(width, height);
        this.sizeCache = new Vector2();
        this.shape = new ChainShape();
        this.vertices = new float[8];
        this.geometry = null;
        this.resize(width, height, ox, oy);
    }

    private void resize(float width, float height) {
        this.vertices[0] = -width / 2.0f;
        this.vertices[1] = -height / 2.0f;
        this.vertices[2] = -width / 2.0f;
        this.vertices[3] = height / 2.0f;
        this.vertices[4] = width / 2.0f;
        this.vertices[5] = height / 2.0f;
        this.vertices[6] = width / 2.0f;
        this.vertices[7] = -height / 2.0f;
        ((ChainShape)this.shape).createLoop(this.vertices);
    }

    private void resize(float width, float height, float ox, float oy) {
        this.vertices[0] = -width / 2.0f + ox;
        this.vertices[1] = -height / 2.0f + oy;
        this.vertices[2] = -width / 2.0f + ox;
        this.vertices[3] = height / 2.0f + oy;
        this.vertices[4] = width / 2.0f + ox;
        this.vertices[5] = height / 2.0f + oy;
        this.vertices[6] = width / 2.0f + ox;
        this.vertices[7] = -height / 2.0f + oy;
        ((ChainShape)this.shape).createLoop(this.vertices);
    }

    public Vector2 getDimension() {
        return this.sizeCache.set(this.dimension);
    }

    public void setDimension(Vector2 value) {
        this.setDimension(value.x, value.y);
    }

    public void setDimension(float width, float height) {
        this.dimension.set(width, height);
        this.markDirty(true);
        this.resize(width, height);
    }

    public float getWidth() {
        return this.dimension.x;
    }

    public void setWidth(float value) {
        this.sizeCache.set(value, this.dimension.y);
        this.setDimension(this.sizeCache);
    }

    public float getHeight() {
        return this.dimension.y;
    }

    public void setHeight(float value) {
        this.sizeCache.set(this.dimension.x, value);
        this.setDimension(this.sizeCache);
    }

    @Override
    protected void createFixtures() {
        if (this.body == null) {
            return;
        }
        this.releaseFixtures();
        this.fixture.shape = this.shape;
        this.geometry = this.body.createFixture(this.fixture);
        this.shape.dispose();
        this.shape = null;
        this.markDirty(false);
    }

    @Override
    protected void releaseFixtures() {
        if (this.geometry != null) {
            this.body.destroyFixture(this.geometry);
            this.geometry = null;
        }
    }

    public boolean isWall() {
        return this.isDefaultWall() || this.isColorWall();
    }

    public boolean isDefaultWall() {
        return this.getType() == GameObject.ObjectType.DEFAULTWALL;
    }

    public boolean isColorWall() {
        return this.getType() == GameObject.ObjectType.COLORWALL;
    }

    public boolean isTopWall() {
        return false;
    }

    public static enum WallType {
        FULL,
        TOP,
        BOT,
        NONE;

    }
}

