/*
 * Decompiled with CFR 0.152.
 */
package com.chrominance.game.Model;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.GridPoint2;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Filter;
import com.badlogic.gdx.physics.box2d.World;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.JsonValue;
import com.chrominance.game.CollisionListener;
import com.chrominance.game.GameCanvas;
import com.chrominance.game.Model.ColorWall;
import com.chrominance.game.Model.DefaultFloor;
import com.chrominance.game.Model.DefaultWall;
import com.chrominance.game.Model.Door;
import com.chrominance.game.Model.EntityObject;
import com.chrominance.game.Model.Exit;
import com.chrominance.game.Model.GameObject;
import com.chrominance.game.Model.GarbageCollector;
import com.chrominance.game.Model.Hole;
import com.chrominance.game.Model.Player;
import com.chrominance.game.Model.PressurePlate;
import com.chrominance.game.Model.TileObject;
import com.chrominance.game.util.FilmStrip;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class WorldModel {
    public JsonValue assetDirectory;
    public JsonValue levelFormat;
    private static final int TILE_WIDTH = 64;
    private static final int PLAYER_WIDTH = 56;
    private static final int GC_WIDTH = 56;
    public boolean finished;
    public float deathAlpha = 0.1f;
    private int width;
    private int height;
    private Player player;
    private Array<GarbageCollector> garbageCollectors;
    public TileList topWalls;
    private Array<GameObject> priority;
    private TileList[][] tileMap;
    private GameObject.ColorMode colorMode;
    private World world;
    private CollisionListener collisionListener;
    private boolean hasSnapshot;
    private boolean drawflashing;
    public static HashMap<Integer, Array<PressurePlate>> pressureSet = new HashMap();
    public HashMap<Integer, Door> doorSet = new HashMap();
    public boolean isPainting = false;
    public FilmStrip painting;
    public ArrayList<GridPoint2> paintedTiles = null;
    private Vector2 originCache;
    private Vector2 hitboxCache;
    private Vector2 positionCache;
    private int counter;

    public void reset() {
        for (int i = 0; i < this.width; ++i) {
            for (int j = 0; j < this.height; ++j) {
                this.tileMap[i][j].clear();
            }
        }
        pressureSet.clear();
        this.doorSet.clear();
        this.topWalls.clear();
        this.priority.clear();
        for (GarbageCollector g : this.garbageCollectors) {
            Object var2_5 = null;
        }
        this.player = null;
    }

    public void setHasSnapshot(Boolean val) {
        this.hasSnapshot = val;
    }

    public boolean getHasSnapshot() {
        return this.hasSnapshot;
    }

    public void setAssetDirectory(JsonValue assetDirectory) {
        this.assetDirectory = assetDirectory;
    }

    public void setLevelFormat(JsonValue levelFormat) {
        this.levelFormat = levelFormat;
    }

    public void init() {
        this.initWorldFromJson();
    }

    public void initWorldFromJson() {
        this.width = this.levelFormat.get("MAP_WIDTH").asInt();
        this.height = this.levelFormat.get("MAP_HEIGHT").asInt();
        this.tileMap = new TileList[this.width][this.height];
        for (int i = 0; i < this.width; ++i) {
            for (int j = 0; j < this.height; ++j) {
                this.tileMap[i][j] = new TileList();
            }
        }
        for (int i = 0; i < this.width; ++i) {
            for (int j = 0; j < this.height; ++j) {
                JsonValue tiles;
                String key = i + "," + j;
                for (JsonValue tile = tiles = this.levelFormat.get(key).child(); tile != null; tile = tile.next()) {
                    this.addTile(tile, i, j);
                }
            }
        }
        JsonValue entities = this.levelFormat.get("ENTITIES").child();
        if (!entities.isNull()) {
            for (JsonValue entity = entities; entity != null; entity = entity.next()) {
                this.addEntity(entity);
            }
        }
        for (Door d : this.doorSet.values()) {
            d.updateGateTextureToGates();
        }
    }

    public WorldModel() {
        this.width = this.width;
        this.height = this.height;
        this.originCache = new Vector2(0.0f, 0.0f);
        this.hitboxCache = new Vector2(0.0f, 0.0f);
        this.positionCache = new Vector2(0.0f, 0.0f);
        this.collisionListener = new CollisionListener(this);
        this.world = new World(this.originCache, true);
        this.world.setContactListener(this.collisionListener);
        this.colorMode = GameObject.ColorMode.NONE;
        this.garbageCollectors = new Array();
        this.topWalls = new TileList();
        this.priority = new Array();
    }

    public World getWorld() {
        return this.world;
    }

    public void updateWorld() {
        for (int i = 0; i < this.width; ++i) {
            for (int j = 0; j < this.height; ++j) {
                for (GameObject o : this.tileMap[i][j]) {
                    Filter f;
                    if (o == null || o.getType() == GameObject.ObjectType.DEFAULTFLOOR) continue;
                    if (o.isActive(this.colorMode)) {
                        f = new Filter();
                        f.maskBits = (short)-1;
                        o.setFilterData(f);
                        f = null;
                        continue;
                    }
                    if (o.getType() == GameObject.ObjectType.DOOR) {
                        if (!((Door)o.getBody().getUserData()).getOpened()) continue;
                        f = new Filter();
                        f.maskBits = 0;
                        o.setFilterData(f);
                        f = null;
                        continue;
                    }
                    if (o.isActive(this.colorMode)) continue;
                    f = new Filter();
                    f.maskBits = 0;
                    o.setFilterData(f);
                    f = null;
                }
            }
        }
    }

    public void addTile(TileObject o, int x, int y) {
        this.tileMap[x][y].add(o);
        o.activatePhysics(this.world);
    }

    public void addTile(JsonValue tile, int x, int y) {
        TileObject o;
        TileObject.WallType wtype;
        boolean isBotWall;
        this.positionCache.set(this.boardToScreen(x), this.boardToScreen(y));
        this.hitboxCache.set(64.0f, 64.0f);
        this.originCache.set(0.0f, 0.0f);
        String type = tile.get("CLASS").asString();
        String tileIdx = "";
        if (tile.get("IS_TILED").asBoolean()) {
            tileIdx = "_" + tile.get("TILE_IDX").asString();
        }
        String texture = (type + tileIdx).toLowerCase();
        boolean isTopWall = tileIdx.equals("_A1") || tileIdx.equals("_B1") || tileIdx.equals("_B2") || tileIdx.equals("_B3");
        boolean bl = isBotWall = tileIdx.equals("_A3") || tileIdx.equals("_B7") || tileIdx.equals("_B8") || tileIdx.equals("_B9");
        TileObject.WallType wallType = isTopWall ? TileObject.WallType.TOP : (wtype = isBotWall ? TileObject.WallType.BOT : TileObject.WallType.FULL);
        if (tile.get("HITBOX").get("SHAPE").asString().equals("BOX")) {
            int hWidth = tile.get("HITBOX").get("WIDTH").asInt();
            int hHeight = tile.get("HITBOX").get("HEIGHT").asInt();
            if (tile.get("HITBOX").has("X")) {
                int hbX = tile.get("HITBOX").get("X").asInt();
                int hbY = tile.get("HITBOX").get("Y").asInt();
                this.originCache.set(hbX, hbY);
            }
            this.hitboxCache.set(hWidth, hHeight);
        }
        switch (type) {
            case "DEFAULT_FLOOR": {
                DefaultFloor o2 = new DefaultFloor(this.positionCache.scl(1.0f / GameObject.gameScale), this.hitboxCache.scl(1.0f / GameObject.gameScale), 64, texture);
                this.tileMap[x][y].add(o2);
                return;
            }
            case "DEFAULT_WALL": {
                o = new DefaultWall(this.positionCache.scl(1.0f / GameObject.gameScale), this.hitboxCache.scl(1.0f / GameObject.gameScale), this.originCache.x / GameObject.gameScale, this.originCache.y / GameObject.gameScale, texture, wtype);
                break;
            }
            case "COLOR_WALL": {
                String cString = tile.get("COLOR_MODE").asString();
                GameObject.ColorMode cMode = this.stringToColorMode(cString);
                texture = texture.replace("color", cString.toLowerCase());
                o = new ColorWall(this.positionCache.scl(1.0f / GameObject.gameScale), this.hitboxCache.scl(1.0f / GameObject.gameScale), this.originCache.x / GameObject.gameScale, this.originCache.y / GameObject.gameScale, cMode, texture, wtype);
                break;
            }
            case "CYAN_HOLE": {
                o = new Hole(this.positionCache.scl(1.0f / GameObject.gameScale), this.hitboxCache.scl(1.0f / GameObject.gameScale), 64, GameObject.ColorMode.CYAN, texture);
                break;
            }
            case "MAGENTA_HOLE": {
                o = new Hole(this.positionCache.scl(1.0f / GameObject.gameScale), this.hitboxCache.scl(1.0f / GameObject.gameScale), 64, GameObject.ColorMode.MAGENTA, texture);
                break;
            }
            case "YELLOW_HOLE": {
                o = new Hole(this.positionCache.scl(1.0f / GameObject.gameScale), this.hitboxCache.scl(1.0f / GameObject.gameScale), 64, GameObject.ColorMode.YELLOW, texture);
                break;
            }
            case "CYAN_PLATE": {
                int setid = tile.get("SET_ID").asInt();
                o = new PressurePlate(this.positionCache.scl(1.0f / GameObject.gameScale), this.hitboxCache.scl(1.0f / GameObject.gameScale), 64, GameObject.ColorMode.CYAN, texture, setid);
                if (pressureSet.containsKey(setid)) {
                    pressureSet.get(setid).add((PressurePlate)o);
                    break;
                }
                Array<PressurePlate> t = new Array<PressurePlate>();
                t.add((PressurePlate)o);
                pressureSet.put(setid, t);
                break;
            }
            case "FULL_PLATE": {
                int setid = tile.get("SET_ID").asInt();
                o = new PressurePlate(this.positionCache.scl(1.0f / GameObject.gameScale), this.hitboxCache.scl(1.0f / GameObject.gameScale), 64, GameObject.ColorMode.NONE, texture, setid);
                if (pressureSet.containsKey(setid)) {
                    pressureSet.get(setid).add((PressurePlate)o);
                    break;
                }
                Array<PressurePlate> t = new Array<PressurePlate>();
                t.add((PressurePlate)o);
                pressureSet.put(setid, t);
                break;
            }
            case "MAGENTA_PLATE": {
                int setid = tile.get("SET_ID").asInt();
                o = new PressurePlate(this.positionCache.scl(1.0f / GameObject.gameScale), this.hitboxCache.scl(1.0f / GameObject.gameScale), 64, GameObject.ColorMode.MAGENTA, texture, setid);
                if (pressureSet.containsKey(setid)) {
                    pressureSet.get(setid).add((PressurePlate)o);
                    break;
                }
                Array<PressurePlate> t = new Array<PressurePlate>();
                t.add((PressurePlate)o);
                pressureSet.put(setid, t);
                break;
            }
            case "YELLOW_PLATE": {
                int setid = tile.get("SET_ID").asInt();
                o = new PressurePlate(this.positionCache.scl(1.0f / GameObject.gameScale), this.hitboxCache.scl(1.0f / GameObject.gameScale), 64, GameObject.ColorMode.YELLOW, texture, setid);
                if (pressureSet.containsKey(setid)) {
                    pressureSet.get(setid).add((PressurePlate)o);
                    break;
                }
                Array<PressurePlate> t = new Array<PressurePlate>();
                t.add((PressurePlate)o);
                pressureSet.put(setid, t);
                break;
            }
            case "GATE": {
                int setid = tile.get("SET_ID").asInt();
                o = new Door(this.positionCache.scl(1.0f / GameObject.gameScale), this.hitboxCache.scl(1.0f / GameObject.gameScale), 64, GameObject.ColorMode.NONE, texture, setid);
                this.doorSet.put(setid, (Door)o);
                break;
            }
            case "EXIT": {
                o = new Exit(this.positionCache.scl(1.0f / GameObject.gameScale), this.hitboxCache.scl(1.0f / GameObject.gameScale), 64, texture);
                break;
            }
            default: {
                DefaultFloor o3 = new DefaultFloor(this.positionCache.scl(1.0f / GameObject.gameScale), this.hitboxCache.scl(1.0f / GameObject.gameScale), 64, "full_hole");
                this.tileMap[x][y].add(o3);
                return;
            }
        }
        this.addTile(o, x, y);
        if (isTopWall) {
            this.topWalls.add(o);
        }
    }

    public static Array<PressurePlate> getPressureSet(int setId) {
        return pressureSet.get(setId);
    }

    public GameObject.ColorMode stringToColorMode(String cString) {
        switch (cString) {
            case "CYAN": {
                return GameObject.ColorMode.CYAN;
            }
            case "MAGENTA": {
                return GameObject.ColorMode.MAGENTA;
            }
            case "YELLOW": {
                return GameObject.ColorMode.YELLOW;
            }
        }
        return GameObject.ColorMode.NONE;
    }

    public void addEntity(JsonValue entityFormat) {
        String type = entityFormat.get("CLASS").asString();
        JsonValue hitbox = entityFormat.get("HITBOX");
        int[] pos = entityFormat.get("POSITION").asIntArray();
        this.positionCache.set(this.boardToScreen(pos[0]), this.boardToScreen(pos[1]));
        if (type.equals("PLAYER")) {
            int hbx = hitbox.get("X").asInt();
            int hby = hitbox.get("Y").asInt();
            int hbwidth = hitbox.get("WIDTH").asInt();
            int hbheight = hitbox.get("HEIGHT").asInt();
            this.player = new Player(this.positionCache.scl(1.0f / GameObject.gameScale), hbx, hby, hbwidth, hbheight);
            this.player.setDensity(0.0f);
            this.player.setFriction(0.0f);
            this.player.setRestitution(0.0f);
            this.player.setName("player");
            this.player.setLinearDamping(10.0f);
            this.player.activatePhysics(this.world);
        }
        if (type.equals("GARBAGE_COLLECTOR")) {
            GameObject.ColorMode gcColor;
            String cString;
            switch (cString = entityFormat.get("COLOR_MODE").asString()) {
                case "CYAN": {
                    gcColor = GameObject.ColorMode.CYAN;
                    break;
                }
                case "MAGENTA": {
                    gcColor = GameObject.ColorMode.MAGENTA;
                    break;
                }
                case "YELLOW": {
                    gcColor = GameObject.ColorMode.YELLOW;
                    break;
                }
                default: {
                    gcColor = GameObject.ColorMode.NONE;
                }
            }
            String roamPath = entityFormat.get("PATROL_PATH").asString();
            GarbageCollector gc = new GarbageCollector(this.positionCache.scl(1.0f / GameObject.gameScale), 0.7f, gcColor, roamPath);
            gc.setDensity(0.0f);
            gc.setFriction(0.0f);
            gc.setRestitution(0.0f);
            gc.setName("GC " + cString);
            gc.setLinearDamping(10.0f);
            gc.activatePhysics(this.world);
            gc.setSensor();
            this.garbageCollectors.add(gc);
        }
    }

    public void removeTile(TileObject o, int x, int y) {
        TileList list = this.tileMap[x][y];
        int idx = 0;
        TileObject temp = list.get(idx);
        while (!temp.equals(o)) {
            temp = list.get(++idx);
        }
        list.tiles.removeIndex(idx);
    }

    public void removeGarbageCollector(EntityObject o) {
        o.markDirty(true);
        this.garbageCollectors.removeValue((GarbageCollector)o, true);
    }

    public void fillHole(Hole hole) {
        this.drawflashing = true;
        hole.markDirty(true);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Player getPlayer() {
        return this.player;
    }

    public Array<GarbageCollector> getGarbageCollectors() {
        return this.garbageCollectors;
    }

    public GameObject.ColorMode getColorMode() {
        return this.colorMode;
    }

    public int getTileSize() {
        return 64;
    }

    public TileList[][] getTileMap() {
        return this.tileMap;
    }

    public void setWorldColor(GameObject.ColorMode color) {
        this.colorMode = color;
    }

    public int screenToBoard(float f) {
        return (int)(f * GameObject.gameScale / (float)this.getTileSize());
    }

    public float boardToScreen(int n) {
        return ((float)n + 0.5f) * (float)this.getTileSize();
    }

    public void paintTiles(GameObject.ColorMode c) {
        this.isPainting = true;
        int x = this.screenToBoard(this.player.getPosition().x);
        int y = this.screenToBoard(this.player.getPosition().y);
        if (this.player.getPaint() < 1) {
            this.isPainting = false;
            return;
        }
        this.player.setPaint(this.player.getPaint() - 1);
        for (int i = x - 1; i < x + 2; ++i) {
            for (int j = y - 1; j <= y + 2; ++j) {
                for (TileObject o : this.tileMap[i][j]) {
                    if (o == null || o.getType() == GameObject.ObjectType.DEFAULTFLOOR || !o.isActive(this.colorMode)) continue;
                    if (o.getColorMode() != c && WorldModel.isPaintable(o)) {
                        if (this.paintedTiles == null) {
                            this.paintedTiles = new ArrayList();
                        }
                        this.paintedTiles.add(new GridPoint2(i, j));
                    }
                    o.switchColorMode(c, true);
                }
            }
        }
        for (GarbageCollector g : this.garbageCollectors) {
            int gx = this.screenToBoard(g.getPosition().x);
            int gy = this.screenToBoard(g.getPosition().y);
            if (gx <= x - 2 || gx >= x + 2 || gy <= y - 2 || gy >= y + 2 || !g.isActive(this.colorMode)) continue;
            g.switchColorMode(c, true);
        }
    }

    public void giveDrawPriority(GameObject o) {
        this.priority.add(o);
    }

    public static boolean isPaintable(TileObject o) {
        switch (o.getType()) {
            case COLORWALL: {
                return true;
            }
            case HOLE: {
                return true;
            }
            case PRESSUREPLATE: {
                return true;
            }
            case GARBAGECOLLECTOR: {
                return true;
            }
        }
        return false;
    }

    public void draw(GameCanvas canvas) {
        canvas.setWorldSize(this.width * 64, this.height * 64);
        float playerX = this.player.getX();
        float playerY = this.player.getY();
        if (this.player.getHealth() < 1) {
            this.deathAlpha = (float)((double)this.deathAlpha - 0.025);
            if (this.deathAlpha < 0.0f) {
                this.deathAlpha = 0.0f;
            }
        } else {
            this.deathAlpha = 1.0f;
        }
        float drawAlpha = this.deathAlpha;
        for (int j = this.height - 1; j >= 0; --j) {
            for (int i = 0; i < this.width; ++i) {
                this.drawTile(this.tileMap[i][j], canvas, drawAlpha);
                if (Math.abs(i - this.screenToBoard(playerX)) < 2 && j - this.screenToBoard(playerY) < 2 && j - this.screenToBoard(playerY) >= 0) {
                    this.player.draw(canvas);
                }
                if (!this.isPainting) continue;
                canvas.draw(this.painting, Color.WHITE, 96.0f, 106.0f, playerX * GameObject.gameScale, playerY * GameObject.gameScale, 0.0f, 1.0f, 1.0f);
            }
        }
        for (int i = 0; i < this.garbageCollectors.size; ++i) {
            if (this.garbageCollectors.get(i).isDirty()) continue;
            if (this.player.getHealth() < 1) {
                this.garbageCollectors.get(i).drawTransparent(canvas, drawAlpha);
                continue;
            }
            if (this.garbageCollectors.get(i).isActive(this.colorMode)) {
                this.garbageCollectors.get(i).draw(canvas);
                continue;
            }
            this.garbageCollectors.get(i).drawTransparent(canvas);
        }
        this.drawPlayer(canvas);
        if (this.drawflashing) {
            if (this.counter < 15) {
                canvas.drawPaintIcon(this);
                ++this.counter;
            } else {
                this.drawflashing = false;
                this.counter = 0;
            }
        }
        for (Door d : this.doorSet.values()) {
            if (this.screenToBoard(d.getX()) != this.screenToBoard(playerX) || this.screenToBoard(d.getY()) != this.screenToBoard(playerY - this.player.getHeight() / (2.0f * GameObject.gameScale)) || d.getOpened()) continue;
            d.draw(canvas);
            break;
        }
        this.drawTopWalls(canvas, drawAlpha);
        while (!this.priority.isEmpty()) {
            this.priority.pop().draw(canvas);
        }
        this.drawTopWalls(canvas, drawAlpha);
    }

    private void drawTile(TileList tiles, GameCanvas canvas, float alpha) {
        for (int i = tiles.getSize() - 1; i >= 0; --i) {
            TileObject tile = tiles.get(i);
            tile.switchColorMode(this.colorMode, false);
            if (alpha < 1.0f) {
                tile.drawTransparent(canvas, alpha);
                continue;
            }
            if (tile.isActive(this.colorMode)) {
                tile.draw(canvas);
                continue;
            }
            if (tile.getType() == GameObject.ObjectType.DOOR && ((Door)tile).getOpened()) continue;
            tile.drawTransparent(canvas);
        }
    }

    private void drawTileNotFloor(TileList tiles, GameCanvas canvas, float alpha) {
        if (tiles.getSize() > 1) {
            for (int i = tiles.getSize() - 2; i >= 0; --i) {
                TileObject tile = tiles.get(i);
                tile.switchColorMode(this.colorMode, false);
                if (alpha < 1.0f) {
                    tile.drawTransparent(canvas, alpha);
                    continue;
                }
                if (tile.isActive(this.colorMode)) {
                    tile.draw(canvas);
                    continue;
                }
                if (tile.getType() == GameObject.ObjectType.DOOR && ((Door)tile).getOpened()) continue;
                tile.drawTransparent(canvas);
            }
        }
    }

    private void drawFloor(TileList tiles, GameCanvas canvas, float drawAlpha) {
        TileObject tile = tiles.get(tiles.getSize() - 1);
        tile.switchColorMode(this.colorMode, false);
        if (drawAlpha < 1.0f) {
            tile.drawTransparent(canvas, drawAlpha);
        } else {
            tile.draw(canvas);
        }
    }

    private void drawTopWalls(GameCanvas canvas, float alpha) {
        for (int i = 0; i < this.topWalls.getSize(); ++i) {
            TileObject t = this.topWalls.get(i);
            if (!(alpha >= 1.0f) || !t.isActive(this.colorMode) || t.getType() == GameObject.ObjectType.COLORWALL && !((ColorWall)t).priority) continue;
            t.draw(canvas);
        }
    }

    public boolean inBounds(int x, int y) {
        return x >= 0 && y >= 0 && x < this.width && y < this.height;
    }

    public void drawPlayer(GameCanvas canvas) {
        this.player.draw(canvas);
    }

    public class TileList
    implements Iterable<TileObject> {
        private Array<TileObject> tiles;
        private TileIterator iterator = new TileIterator();

        public TileList() {
            this.tiles = new Array();
        }

        public TileList(Array<TileObject> tiles) {
            this.tiles = tiles;
        }

        @Override
        public Iterator iterator() {
            this.iterator.pos = 0;
            return this.iterator;
        }

        public void add(TileObject tile) {
            this.tiles.add(tile);
        }

        public TileObject get(int idx) {
            return this.tiles.get(idx);
        }

        public Array<TileObject> getTiles() {
            return this.tiles;
        }

        public int getSize() {
            return this.tiles.size;
        }

        public String toString() {
            return this.tiles.toString();
        }

        public void clear() {
            for (TileObject t : this.tiles) {
                Object var2_2 = null;
            }
        }

        private class TileIterator
        implements Iterator<TileObject> {
            public int pos = 0;

            private TileIterator() {
            }

            @Override
            public TileObject next() {
                if (this.pos >= ((TileList)TileList.this).tiles.size) {
                    throw new NoSuchElementException();
                }
                return (TileObject)TileList.this.tiles.get(this.pos++);
            }

            @Override
            public boolean hasNext() {
                return this.pos < ((TileList)TileList.this).tiles.size;
            }

            @Override
            public void remove() {
                TileList.this.tiles.removeIndex(this.pos);
            }
        }
    }
}

