/*
 * Decompiled with CFR 0.152.
 */
package com.chrominance.game;

import com.badlogic.gdx.Gdx;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.ArrayList;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class SavedGameParser {
    private static JSONObject savedGame = new JSONObject();
    private static JSONParser parser = new JSONParser();
    private static JSONArray levels = new JSONArray();
    private static String gamePath = "jsons/saveFile.json";
    private static ArrayList<String> paths = new ArrayList();

    public static void parse() throws Exception {
        savedGame = (JSONObject)parser.parse(Gdx.files.internal(gamePath).reader());
        levels = (JSONArray)savedGame.get("LEVELS");
        for (int i = 0; i < levels.size(); ++i) {
            paths.add((String)((JSONObject)levels.get(i)).get("PATH"));
        }
    }

    public static String getTutorialText(int level) {
        if (((JSONObject)levels.get(level)).get("TUTORIAL") != null) {
            return (String)((JSONObject)((JSONObject)levels.get(level)).get("TUTORIAL")).get("text");
        }
        return null;
    }

    public static String getTutorialImage(int level) {
        if (((JSONObject)levels.get(level)).get("TUTORIAL") != null) {
            return (String)((JSONObject)((JSONObject)levels.get(level)).get("TUTORIAL")).get("image");
        }
        return null;
    }

    public static boolean[] getLevelsCompleted() {
        boolean[] completed = new boolean[levels.size()];
        for (int i = 0; i < levels.size(); ++i) {
            completed[i] = ((JSONObject)levels.get(i)).get("COMPLETED").equals(true);
        }
        return completed;
    }

    public static boolean[] getLevelsUnlocked() {
        boolean[] unlocked = new boolean[levels.size()];
        for (int i = 0; i < levels.size(); ++i) {
            unlocked[i] = ((JSONObject)levels.get(i)).get("UNLOCKED").equals(true);
        }
        return unlocked;
    }

    public static String getPathToLevel(int level) {
        return paths.get(level);
    }

    public static JSONArray getLevels() {
        return levels;
    }

    public static void completeLevel(int level) {
        ((JSONObject)levels.get(level)).put("COMPLETED", true);
        if (level + 1 < levels.size()) {
            ((JSONObject)levels.get(level + 1)).put("UNLOCKED", true);
        }
    }

    public static void writeToFile() throws Exception {
        BufferedWriter writer = new BufferedWriter(new FileWriter(gamePath));
        writer.write(savedGame.toString());
        writer.close();
    }
}

