/*
 * Decompiled with CFR 0.152.
 */
package com.chrominance.game;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.ButtonGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.chrominance.game.AbstractScreen;
import com.chrominance.game.GDXRoot;
import com.chrominance.game.InputController;

public class SettingsScreen
extends AbstractScreen {
    private static final int COLUMNS = 2;
    private static boolean useWASD = true;
    private static boolean useJKL = true;

    @Override
    public void init() {
        int pad = 10;
        Label movementLabel = new Label((CharSequence)"Movement", skin);
        movementLabel.setAlignment(1);
        final TextButton wasdButton = new TextButton("WASD", skin);
        TextButton arrowsButton = new TextButton("Arrow Keys", skin);
        final ButtonGroup movementGroup = new ButtonGroup((Button[])new TextButton[]{wasdButton, arrowsButton});
        movementGroup.setMaxCheckCount(1);
        movementGroup.setMinCheckCount(1);
        if (useWASD) {
            movementGroup.setChecked("WASD");
        } else {
            movementGroup.setChecked("Arrow Keys");
        }
        this.table.add(movementLabel).colspan(2);
        this.table.row();
        Cell<TextButton> wasdCell = this.table.add(wasdButton);
        wasdCell.left();
        wasdCell.pad(pad);
        Cell<TextButton> arrowsCell = this.table.add(arrowsButton);
        arrowsCell.right();
        arrowsCell.pad(pad);
        this.table.row().padTop(30.0f);
        Label colorLabel = new Label((CharSequence)"Color Switching", skin);
        colorLabel.setAlignment(1);
        final TextButton jklButton = new TextButton("JKL", skin);
        final TextButton asdButton = new TextButton("ASD", skin);
        jklButton.getStyle().checked = skin.getDrawable("ui_cyan_pressed");
        final ButtonGroup colorGroup = new ButtonGroup((Button[])new TextButton[]{jklButton, asdButton});
        colorGroup.setMaxCheckCount(1);
        colorGroup.setMinCheckCount(1);
        if (useJKL) {
            colorGroup.setChecked("JKL");
        } else {
            colorGroup.setChecked("ASD");
        }
        this.table.add(colorLabel).colspan(2);
        this.table.row();
        Cell<TextButton> jklCell = this.table.add(jklButton);
        jklCell.left();
        jklCell.pad(pad);
        Cell<TextButton> asdCell = this.table.add(asdButton);
        asdCell.right();
        asdCell.pad(pad);
        this.table.row().padTop(60.0f);
        asdButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (asdButton.isChecked() && wasdButton.isChecked()) {
                    movementGroup.setChecked("Arrow Keys");
                }
            }
        });
        wasdButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (wasdButton.isChecked() && asdButton.isChecked()) {
                    colorGroup.setChecked("JKL");
                }
            }
        });
        TextButton back = new TextButton("Back", skin);
        back.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                SettingsScreen.this.listener.switchToScreen(GDXRoot.ScreenType.SETTINGS, GDXRoot.ScreenType.MENU, 0);
            }
        });
        Cell<TextButton> backCell = this.table.add(back);
        backCell.left();
        backCell.pad(60.0f, pad, pad, pad);
        TextButton save = new TextButton("Save", skin);
        save.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                useJKL = jklButton.isChecked();
                useWASD = wasdButton.isChecked();
                InputController.setColorKeys(useJKL);
                InputController.setMovementKeys(useWASD);
                SettingsScreen.this.listener.switchToScreen(GDXRoot.ScreenType.SETTINGS, GDXRoot.ScreenType.MENU, 0);
            }
        });
        Cell<TextButton> saveCell = this.table.add(save);
        saveCell.right();
        saveCell.pad(60.0f, pad, pad, pad);
        this.table.setBackground(skin.getDrawable("background"));
    }

    @Override
    public void show() {
        this.takeControl();
    }
}

