/*
 * Decompiled with CFR 0.152.
 */
package com.chrominance.game;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.audio.Sound;

public class SoundController {
    private static String BACKGROUND_MUSIC = "music/game_music_09_post_split_3.mp3";
    private static String MENU_MUSIC = "music/game_music_03.mp3";
    private static String LEVEL_COMPLETE = "music/level_complete.mp3";
    private static String MODE_SWITCH = "music/switch.mp3";
    private static String DOOR_FILE = "music/door.mp3";
    private static String PLAYER_DEATH = "music/color_boy_death.mp3";
    private static String GC_ALERT = "music/gc_alert.mp3";
    private static String GC_DEATH = "music/gc_death.mp3";
    private static String PRESSURE_PLATE = "music/pressure_plate.mp3";
    private static String PAINT_POOF = "music/paint_poof.mp3";
    private static Music bgMusic;
    private static Music menuMusic;
    private static Sound doorOpen;
    private static Sound playerDeath;
    private static Sound levelComplete;
    private static Sound modeSwitch;
    private static Sound gcAlert;
    private static Sound gcDeath;
    private static Sound pressurePlate;
    private static Sound paintPoof;
    public boolean playing = true;
    private static float backgroundMusicVolume;
    private static float menuMusicVolume;
    private static float soundVolume;
    private static SoundController controller;

    public static SoundController getInstance() {
        return controller;
    }

    public static void init() {
        bgMusic = Gdx.audio.newMusic(Gdx.files.internal(BACKGROUND_MUSIC));
        menuMusic = Gdx.audio.newMusic(Gdx.files.internal(MENU_MUSIC));
        doorOpen = Gdx.audio.newSound(Gdx.files.internal(DOOR_FILE));
        playerDeath = Gdx.audio.newSound(Gdx.files.internal(PLAYER_DEATH));
        gcAlert = Gdx.audio.newSound(Gdx.files.internal(GC_ALERT));
        gcDeath = Gdx.audio.newSound(Gdx.files.internal(GC_DEATH));
        pressurePlate = Gdx.audio.newSound(Gdx.files.internal(PRESSURE_PLATE));
        paintPoof = Gdx.audio.newSound(Gdx.files.internal(PAINT_POOF));
        levelComplete = Gdx.audio.newSound(Gdx.files.internal(LEVEL_COMPLETE));
        modeSwitch = Gdx.audio.newSound(Gdx.files.internal(MODE_SWITCH));
    }

    public static void playBackground() {
        if (bgMusic != null && bgMusic.isPlaying()) {
            return;
        }
        bgMusic.setLooping(true);
        bgMusic.setVolume(backgroundMusicVolume);
        bgMusic.setPosition(0.0f);
        bgMusic.play();
    }

    public static void playMenu() {
        if (menuMusic != null) {
            bgMusic.pause();
            if (menuMusic.isPlaying()) {
                return;
            }
        } else {
            menuMusic = Gdx.audio.newMusic(Gdx.files.internal(MENU_MUSIC));
        }
        menuMusic.setLooping(true);
        menuMusic.setVolume(menuMusicVolume);
        menuMusic.setPosition(0.0f);
        menuMusic.play();
    }

    public void disposeMenu() {
        menuMusic.dispose();
    }

    public static void playLevelComplete() {
        levelComplete.play(soundVolume, 3.0f, 0.0f);
    }

    public static void playModeSwitch() {
        modeSwitch.play(soundVolume / 4.0f, 1.5f, 0.0f);
    }

    public static void playPlayerDeath() {
        playerDeath.play(soundVolume);
    }

    public static void playDoorOpen(float f) {
        float v = 1.0f;
        if (f > 15.0f) {
            v = Math.min(1.0f, 2.6666667f * (0.02f / (f / 40.0f)));
        }
        doorOpen.play(v, 1.5f, 0.0f);
    }

    public static void playGCAlert() {
        gcAlert.play(soundVolume, 1.75f, 0.0f);
    }

    public static void playGCDeath() {
        gcDeath.play(soundVolume, 1.5f, 0.0f);
    }

    public static void playPressurePlate(float f) {
        float v = 1.0f;
        if (f > 15.0f) {
            v = Math.min(1.0f, 2.6666667f * (0.02f / (f / 40.0f)));
        }
        pressurePlate.play(v, 1.5f, 0.0f);
    }

    public static void playPaintPoof() {
        paintPoof.play(soundVolume, 1.5f, 0.0f);
    }

    public void dispose() {
        if (bgMusic != null) {
            bgMusic.dispose();
            pressurePlate.dispose();
            gcAlert.dispose();
            gcDeath.dispose();
            doorOpen.dispose();
            playerDeath.dispose();
            menuMusic.dispose();
            paintPoof.dispose();
            bgMusic = null;
            pressurePlate = null;
            gcAlert = null;
            gcDeath = null;
            doorOpen = null;
            playerDeath = null;
            menuMusic = null;
            paintPoof = null;
        }
    }

    static {
        backgroundMusicVolume = 1.0f;
        menuMusicVolume = 1.0f;
        soundVolume = 1.0f;
        controller = new SoundController();
    }
}

