/*
 * Decompiled with CFR 0.152.
 */
package com.chrominance.game;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.chrominance.game.AbstractScreen;
import com.chrominance.game.GDXRoot;
import com.chrominance.game.SavedGameParser;

public class WinScreen
extends AbstractScreen {
    private int level;
    Label winText;

    @Override
    public void init() {
        this.winText = new Label((CharSequence)"", skin);
        TextButton menu = new TextButton("Back to Menu", skin, "cyan");
        TextButton next = new TextButton("Next Level", skin, "cyan");
        menu.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                WinScreen.this.listener.switchToScreen(GDXRoot.ScreenType.WIN, GDXRoot.ScreenType.MENU, 0);
            }
        });
        this.table.setBackground(skin.getDrawable("background"));
        this.table.add(this.winText).colspan(2);
        this.table.row().pad(50.0f, 0.0f, 0.0f, 0.0f);
        if (SavedGameParser.getLevelsCompleted().length > this.level + 1) {
            this.table.add(menu).padRight(50.0f);
            next.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    if (SavedGameParser.getLevelsCompleted().length > WinScreen.this.level + 1) {
                        WinScreen.this.listener.switchToScreen(GDXRoot.ScreenType.WIN, GDXRoot.ScreenType.GAME, WinScreen.this.level + 1);
                    } else {
                        WinScreen.this.listener.switchToScreen(GDXRoot.ScreenType.WIN, GDXRoot.ScreenType.GAME, 0);
                    }
                }
            });
            this.table.addListener(new InputListener(){

                @Override
                public boolean keyUp(InputEvent event, int keycode) {
                    if (event.getKeyCode() == 66) {
                        if (SavedGameParser.getLevelsCompleted().length > WinScreen.this.level + 1) {
                            WinScreen.this.listener.switchToScreen(GDXRoot.ScreenType.WIN, GDXRoot.ScreenType.GAME, WinScreen.this.level + 1);
                        } else {
                            WinScreen.this.listener.switchToScreen(GDXRoot.ScreenType.WIN, GDXRoot.ScreenType.GAME, 0);
                        }
                        return true;
                    }
                    return false;
                }
            });
            this.table.add(next).padLeft(50.0f);
        } else {
            this.table.add(menu);
        }
    }

    @Override
    public void show() {
        this.takeControl();
        this.stage.setKeyboardFocus(this.table);
        SavedGameParser.completeLevel(this.level);
        this.winText.setText("Level " + this.level + " cleared");
        try {
            SavedGameParser.writeToFile();
        }
        catch (Exception e) {
            System.err.println("Could not write to save file");
        }
    }

    public void setLevel(int level) {
        this.level = level;
    }
}

