/*
 * Decompiled with CFR 0.152.
 */
package com.chrominance.game.util;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureRegion;

public class FilmStrip
extends TextureRegion {
    private String name;
    private int cols;
    private int rwidth;
    private int rheight;
    private int originX;
    private int originY;
    private int size;
    private int frame;
    private int start;

    public FilmStrip(Texture texture, int rows, int cols) {
        this(texture, rows, cols, 0, rows * cols);
    }

    public FilmStrip(Texture texture, int rows, int cols, int start, int size) {
        super(texture);
        if (size > rows * cols) {
            Gdx.app.error("FilmStrip", "Invalid strip size", new IllegalArgumentException());
            return;
        }
        this.cols = cols;
        this.size = size;
        this.rwidth = texture.getWidth() / cols;
        this.rheight = texture.getHeight() / rows;
        this.originY = 0;
        this.originX = 0;
        this.start = start;
    }

    public FilmStrip(Texture texture, int rows, int cols, int size) {
        this(texture, rows, cols, 0, size);
    }

    public FilmStrip(TextureRegion region, int rows, int cols, int start, int size, String name) {
        this(region, rows, cols, start, size);
        this.name = name;
    }

    public FilmStrip(TextureRegion region, int rows, int cols, int start, int size) {
        super(region);
        if (size > rows * cols) {
            Gdx.app.error("FilmStrip", "Invalid strip size", new IllegalArgumentException());
            return;
        }
        this.cols = cols;
        this.size = size;
        this.rwidth = region.getRegionWidth() / cols;
        this.rheight = region.getRegionHeight() / rows;
        this.originX = region.getRegionX();
        this.originY = region.getRegionY();
        this.start = start;
    }

    public int getRwidth() {
        return this.rwidth;
    }

    public int getRheight() {
        return this.rheight;
    }

    public int getSize() {
        return this.size;
    }

    public int getFrame() {
        return this.frame;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setFrame(int frame) {
        if (frame < 0 || frame >= this.size) {
            Gdx.app.error("FilmStrip", "Invalid animation frame", new IllegalArgumentException());
            return;
        }
        this.frame = frame;
        int f = this.start + frame;
        int x = (this.originX + f % this.cols * this.rwidth) % (this.cols * this.rwidth);
        int y = this.originY;
        this.setRegion(x, y, this.rwidth, this.rheight);
    }
}

