/*
 * Decompiled with CFR 0.152.
 */
package com.chrominance.game.util;

import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.resolvers.InternalFileHandleResolver;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.g2d.freetype.FreeTypeFontGenerator;
import com.badlogic.gdx.graphics.g2d.freetype.FreeTypeFontGeneratorLoader;
import com.badlogic.gdx.graphics.g2d.freetype.FreetypeFontLoader;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.ObjectMap;
import com.chrominance.game.util.FilmStrip;
import com.chrominance.game.util.SoundController;

public class JsonAssetManager
extends AssetManager {
    private JsonValue directory;
    ObjectMap<String, TextureRegion> regions;
    ObjectMap<String, Texture> textures;
    ObjectMap<String, BitmapFont> fonts;
    ObjectMap<String, Sound> sounds;
    ObjectMap<String, Skin> skins;
    private static JsonAssetManager manager;

    public static JsonAssetManager getInstance() {
        if (manager == null) {
            manager = new JsonAssetManager();
        }
        return manager;
    }

    public static void clearInstance() {
        if (manager != null) {
            manager.clear();
            manager.dispose();
            manager = null;
        }
    }

    private JsonAssetManager() {
        InternalFileHandleResolver resolver = new InternalFileHandleResolver();
        this.setLoader(FreeTypeFontGenerator.class, new FreeTypeFontGeneratorLoader(resolver));
        this.setLoader(BitmapFont.class, ".ttf", new FreetypeFontLoader(resolver));
        this.directory = null;
        this.regions = new ObjectMap();
        this.textures = new ObjectMap();
        this.fonts = new ObjectMap();
        this.sounds = new ObjectMap();
        this.skins = new ObjectMap();
    }

    public void loadDirectory(JsonValue json) {
        assert (this.directory == null) : "Directory has already been loaded; must unload first";
        this.directory = json;
        this.loadTextures();
        this.loadUISkins();
        this.loadSounds();
        this.loadFonts();
    }

    private <T> String getClassIdentifier(Class<T> type) {
        if (type.equals(Texture.class) || type.equals(TextureRegion.class)) {
            return "textures";
        }
        if (type.equals(BitmapFont.class)) {
            return "fonts";
        }
        if (type.equals(Sound.class)) {
            return "sounds";
        }
        if (type.equals(Skin.class)) {
            return "skins";
        }
        assert (false) : "JSON directory does not support this assets class";
        return null;
    }

    private void loadTextures() {
        JsonValue json = this.directory.getChild(this.getClassIdentifier(Texture.class));
        while (json != null) {
            String file = json.getString("file");
            this.load(file, Texture.class);
            json = json.next;
        }
    }

    private void loadUISkins() {
        JsonValue json = this.directory.getChild(this.getClassIdentifier(Skin.class));
        while (json != null) {
            String file = json.getString("file");
            this.load(file, Skin.class);
            json = json.next;
        }
    }

    private void loadFonts() {
        JsonValue json = this.directory.getChild(this.getClassIdentifier(BitmapFont.class));
        while (json != null) {
            FreetypeFontLoader.FreeTypeFontLoaderParameter size2Params = new FreetypeFontLoader.FreeTypeFontLoaderParameter();
            size2Params.fontFileName = json.getString("file");
            size2Params.fontParameters.size = json.getInt("size");
            this.load(size2Params.fontFileName, BitmapFont.class, size2Params);
            json = json.next;
        }
    }

    private void loadSounds() {
        JsonValue json = this.directory.getChild(this.getClassIdentifier(Sound.class));
        while (json != null) {
            String file = json.getString("file");
            this.load(file, Sound.class);
            json = json.next;
        }
    }

    public void unloadDirectory() {
        this.unloadTextures();
        this.unloadSounds();
        this.unloadFonts();
        this.unloadSkins();
        this.directory = null;
    }

    private void unloadTextures() {
        JsonValue json = this.directory.getChild(this.getClassIdentifier(Texture.class));
        while (json != null) {
            String file = json.getString("file");
            if (this.isLoaded(file)) {
                this.unload(file);
                if (this.textures.containsKey(file)) {
                    this.textures.remove(file);
                }
                if (this.regions.containsKey(file)) {
                    this.regions.remove(file);
                }
            }
            json = json.next;
        }
    }

    private void unloadFonts() {
        JsonValue json = this.directory.getChild(this.getClassIdentifier(BitmapFont.class));
        while (json != null) {
            String file = json.getString("file");
            if (this.isLoaded(file)) {
                this.unload(file);
                if (this.fonts.containsKey(file)) {
                    this.fonts.remove(file);
                }
            }
            json = json.next;
        }
    }

    private void unloadSounds() {
        JsonValue json = this.directory.getChild(this.getClassIdentifier(Sound.class));
        while (json != null) {
            String file = json.getString("file");
            if (this.isLoaded(file)) {
                SoundController controller = SoundController.getInstance();
                controller.deallocate(this, file);
                if (this.sounds.containsKey(file)) {
                    this.sounds.remove(file);
                }
            }
            json = json.next;
        }
    }

    private void unloadSkins() {
        JsonValue json = this.directory.getChild(this.getClassIdentifier(Skin.class));
        while (json != null) {
            String file = json.getString("file");
            if (this.isLoaded(file)) {
                this.unload(file);
            }
            json = json.next;
        }
    }

    public void allocateDirectory() {
        JsonValue json = this.directory.getChild(this.getClassIdentifier(Texture.class));
        while (json != null) {
            this.allocateTexture(json);
            json = json.next;
        }
        json = this.directory.getChild(this.getClassIdentifier(BitmapFont.class));
        while (json != null) {
            this.allocateFont(json);
            json = json.next;
        }
        json = this.directory.getChild(this.getClassIdentifier(Sound.class));
        while (json != null) {
            this.allocateSound(json);
            json = json.next;
        }
        json = this.directory.getChild(this.getClassIdentifier(Skin.class));
        while (json != null) {
            this.allocateSkin(json);
            json = json.next;
        }
    }

    private TextureRegion allocateTextureRegion(JsonValue json) {
        String filename = json.getString("file");
        Texture texture = this.get(filename, Texture.class);
        TextureRegion region = new TextureRegion(texture);
        if (json.has("strip")) {
            JsonValue fstrip = json.get("strip");
            int size = fstrip.getInt("size");
            int rows = fstrip.getInt("rows");
            int cols = fstrip.getInt("cols");
            int first = fstrip.getInt("first");
            if (json.has("atlas")) {
                JsonValue atlas;
                for (JsonValue key = atlas = json.get("atlas").child(); key != null; key = key.next()) {
                    String textureKey = json.name() + "_" + key.name();
                    int[] values = key.asIntArray();
                    region = new TextureRegion(texture, values[0], values[1], values[2], values[3]);
                    FilmStrip film = new FilmStrip(region, rows, cols, first, size, textureKey);
                    this.regions.put(textureKey, film);
                }
            } else {
                FilmStrip film = new FilmStrip(texture, rows, cols, first, size);
                film.setName(json.name());
                region = film;
            }
        }
        region.getTexture().setFilter(Texture.TextureFilter.Nearest, Texture.TextureFilter.Nearest);
        if (json.getBoolean("wrap")) {
            region.getTexture().setWrap(Texture.TextureWrap.Repeat, Texture.TextureWrap.Repeat);
        }
        this.regions.put(json.name(), region);
        return region;
    }

    private Texture allocateTexture(JsonValue json) {
        String filename = json.getString("file");
        Texture texture = this.get(filename, Texture.class);
        texture.setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
        if (json.has("strip")) {
            this.allocateTextureRegion(json);
            return texture;
        }
        if (json.getBoolean("wrap")) {
            texture.setWrap(Texture.TextureWrap.Repeat, Texture.TextureWrap.Repeat);
        }
        this.textures.put(json.name(), texture);
        return texture;
    }

    private BitmapFont allocateFont(JsonValue json) {
        String filename = json.getString("file");
        BitmapFont font = this.get(filename, BitmapFont.class);
        this.fonts.put(json.name(), font);
        return font;
    }

    private Sound allocateSound(JsonValue json) {
        String filename = json.getString("file");
        Sound sound = this.get(filename, Sound.class);
        SoundController controller = SoundController.getInstance();
        controller.allocate(this, filename);
        this.sounds.put(json.name(), sound);
        return sound;
    }

    private Skin allocateSkin(JsonValue json) {
        String filename = json.getString("file");
        Skin skin = this.get(filename, Skin.class);
        this.skins.put(json.name(), skin);
        return skin;
    }

    public <T> T getEntry(String key, Class<T> type) {
        try {
            if (type.equals(TextureRegion.class)) {
                return (T)this.regions.get(key);
            }
            if (type.equals(Texture.class)) {
                return (T)this.textures.get(key);
            }
            if (type.equals(BitmapFont.class)) {
                return (T)this.fonts.get(key);
            }
            if (type.equals(Sound.class)) {
                return (T)this.sounds.get(key);
            }
            if (type.equals(Skin.class)) {
                return (T)this.skins.get(key);
            }
        }
        catch (Exception e) {
            return null;
        }
        assert (false) : "JSON directory does not support this assets class";
        return null;
    }
}

