/*
 * Decompiled with CFR 0.152.
 */
package com.chrominance.game.util;

import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.IdentityMap;
import com.badlogic.gdx.utils.ObjectMap;

public class SoundController {
    private static final int DEFAULT_COOL = 20;
    private static final int DEFAULT_LIMIT = 120;
    private static final int DEFAULT_FRAME = 2;
    private static SoundController controller;
    private ObjectMap<String, Sound> soundbank = new ObjectMap();
    private IdentityMap<Sound, String> soundsrc = new IdentityMap();
    private ObjectMap<String, ActiveSound> actives = new ObjectMap();
    private Array<String> collection = new Array();
    private long cooldown = 20L;
    private long timeLimit = 120L;
    private int frameLimit = 2;
    private int current = 0;

    private SoundController() {
    }

    public static SoundController getInstance() {
        if (controller == null) {
            controller = new SoundController();
        }
        return controller;
    }

    public long getCoolDown() {
        return this.cooldown;
    }

    public void setCoolDown(long value) {
        this.cooldown = value;
    }

    public long getTimeLimit() {
        return this.timeLimit;
    }

    public void setTimeLimit(long value) {
        this.timeLimit = value;
    }

    public int getFrameLimit() {
        return this.frameLimit;
    }

    public void setFrameLimit(int value) {
        this.frameLimit = value;
    }

    public void allocate(AssetManager manager, String filename) {
        Sound sound = manager.get(filename, Sound.class);
        this.soundbank.put(filename, sound);
        this.soundsrc.put(sound, filename);
    }

    public void deallocate(AssetManager manager, String filename) {
        Sound sound = manager.get(filename, Sound.class);
        this.soundbank.remove(filename);
        this.soundsrc.remove(sound);
    }

    public String getSource(Sound sound) {
        return this.soundsrc.get(sound);
    }

    public boolean play(String key, String filename, boolean loop) {
        return this.play(key, filename, loop, 1.0f);
    }

    public boolean play(String key, String filename, boolean loop, float volume) {
        long id;
        if (!this.soundbank.containsKey(filename) || this.current >= this.frameLimit) {
            return false;
        }
        Sound sound = this.soundbank.get(filename);
        if (this.actives.containsKey(key)) {
            ActiveSound snd = this.actives.get(key);
            if (!snd.loop && snd.lifespan > this.cooldown) {
                snd.sound.setVolume(snd.id, 0.0f);
            } else {
                return true;
            }
        }
        if ((id = sound.play(volume)) == -1L) {
            return false;
        }
        if (loop) {
            sound.setLooping(id, true);
        }
        this.actives.put(key, new ActiveSound(sound, id, loop));
        ++this.current;
        return true;
    }

    public void stop(String key) {
        if (!this.actives.containsKey(key)) {
            return;
        }
        ActiveSound snd = this.actives.get(key);
        snd.sound.setLooping(snd.id, false);
        snd.sound.setVolume(snd.id, 0.0f);
        this.actives.remove(key);
    }

    public boolean isActive(String key) {
        return this.actives.containsKey(key);
    }

    public void update() {
        for (String key : this.actives.keys()) {
            ActiveSound snd = this.actives.get(key);
            ++snd.lifespan;
            if (snd.lifespan <= this.timeLimit) continue;
            this.collection.add(key);
            snd.sound.setLooping(snd.id, false);
            snd.sound.setVolume(snd.id, 0.0f);
        }
        for (String key : this.collection) {
            this.actives.remove(key);
        }
        this.collection.clear();
        this.current = 0;
    }

    private class ActiveSound {
        public Sound sound;
        public long id;
        public boolean loop;
        public long lifespan;

        public ActiveSound(Sound s, long n, boolean b) {
            this.sound = s;
            this.id = n;
            this.loop = b;
            this.lifespan = 0L;
        }
    }
}

